/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.ui.actions.TwoStepCompletionProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class VcsRefCompletionProvider
extends TwoStepCompletionProvider<VcsRef> {
    @NotNull
    private final VcsLogRefs myRefs;
    @NotNull
    private final Set<VirtualFile> myRoots;

    public VcsRefCompletionProvider(@NotNull VcsLogRefs refs, @NotNull Collection<? extends VirtualFile> roots, @NotNull TextCompletionValueDescriptor<VcsRef> descriptor) {
        super(descriptor);
        this.myRefs = refs;
        this.myRoots = new HashSet<VirtualFile>(roots);
    }

    @Override
    @NotNull
    protected Stream<? extends VcsRef> collectSync(@NotNull CompletionResultSet result2) {
        return this.filterAndSort(result2, this.myRefs.getBranches().stream());
    }

    @Override
    @NotNull
    protected Stream<? extends VcsRef> collectAsync(@NotNull CompletionResultSet result2) {
        return this.filterAndSort(result2, this.myRefs.stream().filter(ref -> !ref.getType().isBranch()));
    }

    @NotNull
    private Stream<VcsRef> filterAndSort(@NotNull CompletionResultSet result2, @NotNull Stream<VcsRef> stream) {
        Stream<VcsRef> matched = stream.filter(ref -> this.myRoots.contains(ref.getRoot()) && result2.getPrefixMatcher().prefixMatches(ref.getName()));
        return this.filterRefs(matched);
    }

    @NotNull
    protected Stream<VcsRef> filterRefs(@NotNull Stream<VcsRef> vcsRefs) {
        return vcsRefs;
    }
}

