/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ShowDiffAfterWithLocalFromLogActionProvider
implements AnActionExtensionProvider {
    public boolean isActive(@NotNull AnActionEvent e) {
        return e.getData(VcsLogDataKeys.VCS_LOG) != null && e.getData(ChangesBrowserBase.DATA_KEY) == null;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        if (project == null || log == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        List commits = log.getSelectedCommits();
        if (commits.size() != 1) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(e.getData(VcsLogInternalDataKeys.LOG_DIFF_HANDLER) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VcsLogUsageTriggerCollector.triggerUsage(e, this);
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLog log = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        List commits = log.getSelectedCommits();
        if (commits.size() != 1) {
            return;
        }
        CommitId commit = (CommitId)Objects.requireNonNull(ContainerUtil.getFirstItem((List)commits));
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        VcsLogDiffHandler handler = (VcsLogDiffHandler)e.getRequiredData(VcsLogInternalDataKeys.LOG_DIFF_HANDLER);
        handler.showDiffForPaths(commit.getRoot(), VcsLogUtil.getAffectedPaths(commit.getRoot(), e), commit.getHash(), null);
    }
}

