/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.actions.BooleanPropertyToggleAction;
import com.intellij.vcs.log.ui.table.VcsLogColumn;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreferCommitDateAction
extends BooleanPropertyToggleAction
implements DumbAware {
    public PreferCommitDateAction() {
        super(VcsBundle.messagePointer((String)"prefer.commit.timestamp.action.text", (Object[])new Object[0]), VcsBundle.messagePointer((String)"prefer.commit.timestamp.action.description", (Object[])new Object[0]), null);
    }

    @Override
    protected VcsLogUiProperties.VcsLogUiProperty<Boolean> getProperty() {
        return CommonUiProperties.PREFER_COMMIT_DATE;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        VcsLogData data = (VcsLogData)e.getData(VcsLogInternalDataKeys.LOG_DATA);
        VcsLogUi logUi = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (data == null || logUi == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Map<VirtualFile, VcsLogProvider> providers = data.getLogProviders();
        if (!PreferCommitDateAction.isCommitDateSupported(providers.values())) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Set visibleProviders = ContainerUtil.map2SetNotNull(VcsLogUtil.getVisibleRoots(logUi), root -> (VcsLogProvider)providers.get(root));
        if (!PreferCommitDateAction.isDateDisplayed((VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES)) || !PreferCommitDateAction.isCommitDateSupported(visibleProviders)) {
            e.getPresentation().setEnabled(false);
        }
    }

    private static boolean isCommitDateSupported(@NotNull Collection<VcsLogProvider> providers) {
        return providers.stream().anyMatch(arg_0 -> ((VcsLogProperties.VcsLogProperty)VcsLogProperties.HAS_COMMITTER).getOrDefault(arg_0));
    }

    private static boolean isDateDisplayed(@Nullable VcsLogUiProperties properties) {
        if (properties != null && properties.exists(CommonUiProperties.COLUMN_ORDER)) {
            List<Integer> columnOrder = properties.get(CommonUiProperties.COLUMN_ORDER);
            return columnOrder.contains(VcsLogColumn.DATE.ordinal());
        }
        return false;
    }
}

