/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.impl.VcsGoToRefComparator;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.actions.GoToHashOrRefPopup;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.Set;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class GoToHashOrRefAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLog log = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        VcsLogUiEx logUi = (VcsLogUiEx)e.getRequiredData(VcsLogInternalDataKeys.LOG_UI_EX);
        VcsLogManager logManager = (VcsLogManager)e.getRequiredData(VcsLogInternalDataKeys.LOG_MANAGER);
        Set<VirtualFile> visibleRoots = VcsLogUtil.getVisibleRoots(logUi);
        GoToHashOrRefPopup popup = new GoToHashOrRefPopup(project, logUi.getDataPack().getRefs(), visibleRoots, (Function<? super String, ? extends Future>)((Function)arg_0 -> ((VcsLog)log).jumpToReference(arg_0)), (Function<? super VcsRef, ? extends Future>)((Function)vcsRef -> logUi.jumpToCommit(vcsRef.getCommitHash(), vcsRef.getRoot())), logManager.getColorManager(), new VcsGoToRefComparator(logUi.getDataPack().getLogProviders()));
        popup.show((JComponent)((Object)logUi.getTable()));
    }

    public void update(@NotNull AnActionEvent e) {
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        VcsLogUiEx logUi = (VcsLogUiEx)e.getData(VcsLogInternalDataKeys.LOG_UI_EX);
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && log != null && logUi != null);
    }
}

