/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.actions.BooleanPropertyToggleAction;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EnableMatchCaseAction
extends BooleanPropertyToggleAction {
    @Override
    protected VcsLogUiProperties.VcsLogUiProperty<Boolean> getProperty() {
        return MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        VcsLogUi ui2 = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
        if (ui2 != null && properties != null && properties.exists(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE)) {
            boolean regexEnabled;
            boolean bl = regexEnabled = properties.exists(MainVcsLogUiProperties.TEXT_FILTER_REGEX) && properties.get(MainVcsLogUiProperties.TEXT_FILTER_REGEX) != false;
            if (!regexEnabled) {
                e.getPresentation().setText(VcsLogBundle.message((String)"action.title.match.case", (Object[])new Object[0]));
            } else {
                LinkedHashSet providers = new LinkedHashSet(ui2.getDataPack().getLogProviders().values());
                List supported = ContainerUtil.filter(providers, arg_0 -> ((VcsLogProperties.VcsLogProperty)VcsLogProperties.CASE_INSENSITIVE_REGEX).getOrDefault(arg_0));
                e.getPresentation().setVisible(true);
                e.getPresentation().setEnabled(!supported.isEmpty());
                if (providers.size() == supported.size() || supported.isEmpty()) {
                    e.getPresentation().setText(VcsLogBundle.message((String)"action.title.match.case", (Object[])new Object[0]));
                } else {
                    String supportedText = StringUtil.join((Collection)ContainerUtil.map((Collection)supported, p -> StringUtil.toLowerCase((String)p.getSupportedVcs().getName())), (String)", ");
                    e.getPresentation().setText(VcsLogBundle.message((String)"action.title.match.case.only.supported", (Object[])new Object[]{supportedText}));
                }
            }
        }
    }
}

