/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.actions.ActionController;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

abstract class CollapseOrExpandGraphAction
extends DumbAwareAction {
    private final Supplier<String> myLinearBranchesAction;
    private final Supplier<String> myLinearBranchesDescription;
    private final Supplier<String> myMergesAction;
    private final Supplier<String> myMergesDescription;

    protected CollapseOrExpandGraphAction(@NotNull Supplier<String> linearBranchesAction, @NotNull Supplier<String> linearBranchesDescription, @NotNull Supplier<String> mergesAction, @NotNull Supplier<String> mergesDescription) {
        super(linearBranchesAction, linearBranchesDescription, null);
        this.myLinearBranchesAction = linearBranchesAction;
        this.myLinearBranchesDescription = linearBranchesDescription;
        this.myMergesAction = mergesAction;
        this.myMergesDescription = mergesDescription;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        this.executeAction((MainVcsLogUi)e.getRequiredData(VcsLogInternalDataKeys.MAIN_UI));
    }

    public void update(@NotNull AnActionEvent e) {
        MainVcsLogUi ui2 = (MainVcsLogUi)e.getData(VcsLogInternalDataKeys.MAIN_UI);
        VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
        boolean visible = ui2 != null && ui2.getDataPack().getVisibleGraph().getActionController().isActionSupported(this.getGraphAction());
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && !ui2.getDataPack().isEmpty());
        if (visible) {
            if (properties != null && properties.exists(MainVcsLogUiProperties.BEK_SORT_TYPE) && properties.get(MainVcsLogUiProperties.BEK_SORT_TYPE) == PermanentGraph.SortType.LinearBek) {
                e.getPresentation().setText(this.myMergesAction.get());
                e.getPresentation().setDescription(this.myMergesDescription.get());
            } else {
                e.getPresentation().setText(this.myLinearBranchesAction.get());
                e.getPresentation().setDescription(this.myLinearBranchesDescription.get());
            }
        }
    }

    protected abstract void executeAction(@NotNull MainVcsLogUi var1);

    @NotNull
    protected abstract GraphAction getGraphAction();

    protected void performLongAction(@NotNull MainVcsLogUi logUi, @NotNull GraphAction graphAction, @NotNull String title2) {
        VisiblePack dataPack = logUi.getDataPack();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ActionController actionController = dataPack.getVisibleGraph().getActionController();
            GraphAnswer answer = actionController.performAction(graphAction);
            Runnable updater = answer.getGraphUpdater();
            ApplicationManager.getApplication().invokeLater(() -> {
                assert (updater != null) : "Action:" + title2 + "\nController: " + actionController + "\nAnswer:" + answer;
                updater.run();
                logUi.getTable().handleAnswer((GraphAnswer<Integer>)answer);
            });
        }, title2, false, null, logUi.getMainComponent());
    }
}

