/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsLogColorManagerImpl
implements VcsLogColorManager {
    private static final Logger LOG = Logger.getInstance(VcsLogColorManagerImpl.class);
    private static final Color[] ROOT_COLORS = new Color[]{JBColor.RED, JBColor.GREEN, JBColor.BLUE, JBColor.ORANGE, JBColor.CYAN, JBColor.YELLOW, JBColor.MAGENTA, JBColor.PINK};
    @NotNull
    private final Map<String, Color> myPaths2Colors;
    @NotNull
    private final List<FilePath> myPaths;

    public VcsLogColorManagerImpl(@NotNull Set<VirtualFile> roots) {
        this(ContainerUtil.map((Collection)ContainerUtil.sorted(roots, Comparator.comparing(VirtualFile::getName)), file -> VcsUtil.getFilePath((VirtualFile)file)));
    }

    public VcsLogColorManagerImpl(@NotNull Collection<FilePath> paths) {
        this.myPaths = new ArrayList<FilePath>(paths);
        this.myPaths2Colors = new HashMap<String, Color>();
        for (int i = 0; i < this.myPaths.size(); ++i) {
            this.myPaths2Colors.put(this.myPaths.get(i).getPath(), VcsLogColorManagerImpl.getColor(i, this.myPaths.size()));
        }
    }

    @NotNull
    private static Color getColor(int rootNumber, int rootsCount) {
        Color color;
        if (rootNumber >= ROOT_COLORS.length) {
            double balance = (double)(rootNumber / ROOT_COLORS.length) / (double)(rootsCount / ROOT_COLORS.length);
            Color mix = ColorUtil.mix((Color)ROOT_COLORS[rootNumber % ROOT_COLORS.length], (Color)ROOT_COLORS[(rootNumber + 1) % ROOT_COLORS.length], (double)balance);
            int tones = (int)(Math.abs(balance - 0.5) * 2.0 * (double)(rootsCount / ROOT_COLORS.length) + 1.0);
            color = new JBColor(ColorUtil.darker((Color)mix, (int)tones), ColorUtil.brighter((Color)mix, (int)(2 * tones)));
        } else {
            color = ROOT_COLORS[rootNumber];
        }
        return color;
    }

    @NotNull
    public static JBColor getBackgroundColor(@NotNull Color baseRootColor) {
        return new JBColor(() -> ColorUtil.mix((Color)baseRootColor, (Color)UIUtil.getTableBackground(), (double)0.75));
    }

    @Override
    @NotNull
    public Color getPathColor(@NotNull FilePath path2) {
        return this.getColor(path2.getPath());
    }

    @Override
    @NotNull
    public Color getRootColor(@NotNull VirtualFile root) {
        return this.getColor(root.getPath());
    }

    @NotNull
    private Color getColor(@NotNull String path2) {
        Color color = this.myPaths2Colors.get(path2);
        if (color == null) {
            LOG.error("No color record for path " + path2 + ". All paths: " + this.myPaths2Colors);
            color = VcsLogColorManagerImpl.getDefaultRootColor();
        }
        return color;
    }

    @NotNull
    private static Color getDefaultRootColor() {
        return UIUtil.getTableBackground();
    }

    @Override
    @NotNull
    public Collection<FilePath> getPaths() {
        return this.myPaths;
    }
}

