/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabGroupId;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.Consumer;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsLogContentUtil {
    @Nullable
    public static VcsLogUiEx getLogUi(@NotNull JComponent c) {
        return (VcsLogUiEx)ContainerUtil.getFirstItem(VcsLogContentUtil.getLogUis(c));
    }

    public static List<VcsLogUiEx> getLogUis(@NotNull JComponent c) {
        HashSet<VcsLogPanel> panels = new HashSet<VcsLogPanel>();
        VcsLogContentUtil.collectLogPanelInstances(c, panels);
        return ContainerUtil.map(panels, VcsLogPanel::getUi);
    }

    private static void collectLogPanelInstances(@NotNull JComponent component, @NotNull Set<VcsLogPanel> result2) {
        if (component instanceof VcsLogPanel) {
            result2.add((VcsLogPanel)((Object)component));
            return;
        }
        for (Component childComponent : component.getComponents()) {
            if (!(childComponent instanceof JComponent)) continue;
            VcsLogContentUtil.collectLogPanelInstances((JComponent)childComponent, result2);
        }
    }

    @Nullable
    public static <U extends VcsLogUiEx> U findAndSelect(@NotNull Project project, @NotNull Class<U> clazz, @NotNull Condition<? super U> condition) {
        return VcsLogContentUtil.find(project, clazz, true, condition);
    }

    @Nullable
    public static <U extends VcsLogUiEx> U find(@NotNull Project project, @NotNull Class<U> clazz, boolean select, @NotNull Condition<? super U> condition) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Version Control");
        if (toolWindow == null) {
            return null;
        }
        ContentManager manager = toolWindow.getContentManager();
        JComponent component = ContentUtilEx.findContentComponent((ContentManager)manager, c -> {
            VcsLogUiEx ui2 = VcsLogContentUtil.getLogUi(c);
            if (ui2 != null) {
                return clazz.isInstance(ui2) && condition.value((Object)ui2);
            }
            return false;
        });
        if (component == null) {
            return null;
        }
        if (select) {
            if (!toolWindow.isVisible()) {
                toolWindow.activate(null);
            }
            if (!ContentUtilEx.selectContent((ContentManager)manager, (JComponent)component, (boolean)true)) {
                return null;
            }
        }
        return (U)VcsLogContentUtil.getLogUi(component);
    }

    @Nullable
    public static String getId(@NotNull Content content2) {
        VcsLogUiEx ui2 = VcsLogContentUtil.getLogUi(content2.getComponent());
        if (ui2 == null) {
            return null;
        }
        return ui2.getId();
    }

    @NotNull
    public static Set<String> getExistingLogIds(@NotNull Project project) {
        ContentManager contentManager = ToolWindowManager.getInstance((Project)project).getToolWindow("Version Control").getContentManager();
        TabbedContent tabbedContent = ContentUtilEx.findTabbedContent((ContentManager)contentManager, (String)VcsLogContentProvider.TAB_NAME);
        Set existingIds = tabbedContent != null ? ContainerUtil.map2SetNotNull((Collection)tabbedContent.getTabs(), pair -> {
            VcsLogUiEx ui2 = VcsLogContentUtil.getLogUi((JComponent)pair.second);
            if (ui2 == null) {
                return null;
            }
            return ui2.getId();
        }) : ContainerUtil.map2SetNotNull(Arrays.asList(contentManager.getContents()), content2 -> {
            TabGroupId groupId = (TabGroupId)content2.getUserData(Content.TAB_GROUP_ID_KEY);
            if (groupId == null || !VcsLogContentProvider.TAB_NAME.equals(groupId.getId())) {
                return null;
            }
            return VcsLogContentUtil.getId(content2);
        });
        return existingIds;
    }

    public static <U extends VcsLogUiEx> U openLogTab(@NotNull Project project, @NotNull VcsLogManager logManager, @NotNull @NonNls String groupId, @NotNull Supplier<String> tabGroupDisplayName, @NotNull Function<U, String> tabDisplayName, @NotNull VcsLogManager.VcsLogUiFactory<U> factory, boolean focus) {
        Object logUi = logManager.createLogUi(factory, VcsLogManager.LogWindowKind.TOOL_WINDOW);
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Version Control");
        ContentUtilEx.addTabbedContent((ContentManager)toolWindow.getContentManager(), (JComponent)((Object)new VcsLogPanel(logManager, (VcsLogUiEx)logUi)), (String)groupId, tabGroupDisplayName, () -> (String)tabDisplayName.apply(logUi), (boolean)focus, logUi);
        if (focus) {
            toolWindow.activate(null);
        }
        logManager.scheduleInitialization();
        return logUi;
    }

    public static boolean closeLogTab(@NotNull ContentManager manager, @NotNull String tabId) {
        return ContentUtilEx.closeContentTab((ContentManager)manager, c -> {
            VcsLogUiEx ui2 = VcsLogContentUtil.getLogUi(c);
            if (ui2 != null) {
                return ui2.getId().equals(tabId);
            }
            return false;
        });
    }

    @Deprecated
    public static void openMainLogAndExecute(@NotNull Project project, @NotNull Consumer<? super VcsLogUiImpl> consumer) {
        VcsLogContentUtil.runInMainLog(project, (Consumer<? super MainVcsLogUi>)((Consumer)ui2 -> consumer.consume((Object)((VcsLogUiImpl)ui2))));
    }

    public static void runInMainLog(@NotNull Project project, @NotNull Consumer<? super MainVcsLogUi> consumer) {
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow("Version Control");
        if (window == null || !VcsLogContentUtil.selectMainLog(window.getContentManager())) {
            VcsLogContentUtil.showLogIsNotAvailableMessage(project);
            return;
        }
        Runnable runConsumer = () -> Objects.requireNonNull(VcsLogContentProvider.getInstance(project)).executeOnMainUiCreated(consumer);
        if (!window.isVisible()) {
            window.activate(runConsumer);
        } else {
            runConsumer.run();
        }
    }

    public static void showLogIsNotAvailableMessage(@NotNull Project project) {
        VcsBalloonProblemNotifier.showOverChangesView(project, VcsLogBundle.message((String)"vcs.log.is.not.available", (Object[])new Object[0]), MessageType.WARNING, new NamedRunnable[0]);
    }

    public static boolean selectMainLog(@NotNull ContentManager cm) {
        Content[] contents;
        for (Content content2 : contents = cm.getContents()) {
            if (!VcsLogContentProvider.TAB_NAME.equals(content2.getTabName())) continue;
            cm.setSelectedContent(content2);
            return true;
        }
        return false;
    }

    public static void updateLogUiName(@NotNull Project project, @NotNull VcsLogUi ui2) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Version Control");
        if (toolWindow == null) {
            return;
        }
        ContentManager manager = toolWindow.getContentManager();
        JComponent component = ContentUtilEx.findContentComponent((ContentManager)manager, c -> ui2 == VcsLogContentUtil.getLogUi(c));
        if (component == null) {
            return;
        }
        ContentUtilEx.updateTabbedContentDisplayName((ContentManager)manager, (JComponent)component);
    }

    @Deprecated
    @Nullable
    public static VcsLogManager getOrCreateLog(@NotNull Project project) {
        return VcsProjectLog.getOrCreateLog(project);
    }
}

