/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentEP;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabsManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogContentProvider
implements ChangesViewContentProvider {
    private static final Logger LOG = Logger.getInstance(VcsLogContentProvider.class);
    @NonNls
    public static String TAB_NAME = "Log";
    @NotNull
    private final VcsProjectLog myProjectLog;
    @NotNull
    private final JPanel myContainer = new JBPanel((LayoutManager)new BorderLayout());
    @Nullable
    private Consumer<? super MainVcsLogUi> myOnCreatedListener;
    @Nullable
    private MainVcsLogUi myUi;
    @Nullable
    private Content myContent;

    public VcsLogContentProvider(@NotNull Project project, @NotNull VcsProjectLog projectLog) {
        this.myProjectLog = projectLog;
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)projectLog);
        connection.subscribe(VcsProjectLog.VCS_PROJECT_LOG_CHANGED, (Object)new VcsProjectLog.ProjectLogListener(){

            @Override
            public void logCreated(@NotNull VcsLogManager logManager) {
                VcsLogContentProvider.this.addMainUi(logManager);
            }

            @Override
            public void logDisposed(@NotNull VcsLogManager logManager) {
                VcsLogContentProvider.this.disposeMainUi();
            }
        });
        VcsLogManager manager = this.myProjectLog.getLogManager();
        if (manager != null) {
            this.addMainUi(manager);
        }
    }

    @Nullable
    public MainVcsLogUi getUi() {
        return this.myUi;
    }

    @Override
    public void initTabContent(@NotNull Content content2) {
        this.myContent = content2;
        this.myContent.setTabName(TAB_NAME);
        this.updateDisplayName();
        this.myProjectLog.createLogInBackground(true);
        content2.setComponent((JComponent)this.myContainer);
        content2.setDisposer(() -> {
            this.disposeContent();
            this.myContent = null;
        });
    }

    private void addMainUi(@NotNull VcsLogManager logManager) {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        if (this.myUi == null) {
            this.myUi = logManager.createLogUi("MAIN", VcsLogManager.LogWindowKind.TOOL_WINDOW, false);
            VcsLogPanel panel2 = this.createPanel(logManager, this.myUi);
            this.myContainer.add((Component)((Object)panel2), "Center");
            DataManager.registerDataProvider((JComponent)this.myContainer, (DataProvider)panel2);
            this.updateDisplayName();
            this.myUi.addFilterListener(this::updateDisplayName);
            if (this.myOnCreatedListener != null) {
                this.myOnCreatedListener.consume((Object)this.myUi);
            }
            this.myOnCreatedListener = null;
        }
    }

    private void updateDisplayName() {
        if (this.myContent != null && this.myUi != null) {
            this.myContent.setDisplayName(VcsLogTabsManager.generateDisplayName(this.myUi));
        }
    }

    @NotNull
    protected VcsLogPanel createPanel(@NotNull VcsLogManager logManager, @NotNull VcsLogUiEx ui2) {
        return new VcsLogPanel(logManager, ui2);
    }

    private void disposeMainUi() {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        this.myContainer.removeAll();
        DataManager.removeDataProvider((JComponent)this.myContainer);
        this.myOnCreatedListener = null;
        if (this.myUi != null) {
            MainVcsLogUi ui2 = this.myUi;
            this.myUi = null;
            Disposer.dispose((Disposable)ui2);
        }
    }

    public void executeOnMainUiCreated(@NotNull Consumer<? super MainVcsLogUi> consumer) {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        if (this.myUi == null) {
            this.myOnCreatedListener = consumer;
        } else {
            consumer.consume((Object)this.myUi);
        }
    }

    @Override
    public void disposeContent() {
        this.disposeMainUi();
    }

    @Nullable
    public static VcsLogContentProvider getInstance(@NotNull Project project) {
        for (ChangesViewContentEP ep : ChangesViewContentEP.EP_NAME.getExtensions((AreaInstance)project)) {
            if (!ep.getClassName().equals(VcsLogContentProvider.class.getName())) continue;
            return (VcsLogContentProvider)ep.getCachedInstance();
        }
        return null;
    }

    public static class DisplayNameSupplier
    implements Supplier<String> {
        @Override
        public String get() {
            return VcsLogBundle.message((String)"vcs.log.tab.name", (Object[])new Object[0]);
        }
    }

    public static class VcsLogVisibilityPredicate
    implements NotNullFunction<Project, Boolean> {
        @NotNull
        public Boolean fun(@NotNull Project project) {
            return !VcsProjectLog.getLogProviders(project).isEmpty();
        }
    }
}

