/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeavyAwareExecutor
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ListeningExecutorService myExecutorService;
    private final int myDelayMs;
    private final int myLongActivityDurationMs;

    public HeavyAwareExecutor(@NotNull Project project, int delayMs, int longActivityDurationMs, @NotNull Disposable parent) {
        this.myProject = project;
        this.myDelayMs = delayMs;
        this.myLongActivityDurationMs = longActivityDurationMs;
        this.myExecutorService = MoreExecutors.listeningDecorator((ExecutorService)AppExecutorUtil.getAppExecutorService());
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public Future<?> executeOutOfHeavyOrPowerSave(@NotNull Consumer<? super ProgressIndicator> task2, @NotNull ProgressIndicator indicator) {
        ExecutingHeavyOrPowerSaveListener executingListener = new ExecutingHeavyOrPowerSaveListener(this.myProject, this.myDelayMs, this, () -> {
            ListenableFuture<?> future2 = this.runAsync(task2, indicator);
            Disposable disposable = Disposer.newDisposable();
            future2.addListener(() -> Disposer.dispose((Disposable)disposable), MoreExecutors.directExecutor());
            new CancellingOnHeavyOrPowerSaveListener(this.myProject, indicator, this.myLongActivityDurationMs, disposable);
            return future2;
        });
        return Futures.transformAsync(executingListener.getFuture(), input -> input, (Executor)MoreExecutors.directExecutor());
    }

    @NotNull
    private ListenableFuture<?> runAsync(@NotNull Consumer<? super ProgressIndicator> task2, @NotNull ProgressIndicator indicator) {
        Runnable taskWithProgress = () -> ProgressManager.getInstance().runProcess(() -> task2.consume((Object)indicator), indicator);
        return this.myExecutorService.submit(taskWithProgress);
    }

    public void dispose() {
    }

    public static void executeOutOfHeavyProcessLater(@NotNull Runnable command, int delayMs) {
        HeavyProcessLatch.INSTANCE.executeOutOfHeavyProcess(() -> JobScheduler.getScheduler().schedule(() -> {
            if (HeavyProcessLatch.INSTANCE.isRunning()) {
                HeavyAwareExecutor.executeOutOfHeavyProcessLater(command, delayMs);
            } else {
                command.run();
            }
        }, (long)delayMs, TimeUnit.MILLISECONDS));
    }

    private static class ExecutingHeavyOrPowerSaveListener
    implements PowerSaveMode.Listener,
    Disposable {
        @NotNull
        private final AtomicReference<Computable<ListenableFuture<?>>> myTask = new AtomicReference<Object>(null);
        private final int myDelayMs;
        private final SettableFuture<ListenableFuture<?>> myFuture;

        ExecutingHeavyOrPowerSaveListener(@NotNull Project project, int delayMs, @NotNull Disposable parent, @NotNull Computable<ListenableFuture<?>> task2) {
            this.myDelayMs = delayMs;
            this.myFuture = SettableFuture.create();
            this.myTask.set(task2);
            project.getMessageBus().connect((Disposable)this).subscribe(PowerSaveMode.TOPIC, (Object)this);
            Disposer.register((Disposable)parent, (Disposable)this);
            this.tryRun();
        }

        @NotNull
        public ListenableFuture<ListenableFuture<?>> getFuture() {
            return this.myFuture;
        }

        public void powerSaveStateChanged() {
            this.tryRun();
        }

        private void tryRun() {
            if (!PowerSaveMode.isEnabled()) {
                HeavyProcessLatch.INSTANCE.executeOutOfHeavyProcess(() -> JobScheduler.getScheduler().schedule(() -> {
                    if (!HeavyProcessLatch.INSTANCE.isRunning() && !PowerSaveMode.isEnabled()) {
                        Disposer.dispose((Disposable)this);
                        Computable task2 = this.myTask.getAndSet(null);
                        if (task2 != null) {
                            this.runTask(task2);
                        }
                    } else {
                        this.tryRun();
                    }
                }, (long)this.myDelayMs, TimeUnit.MILLISECONDS));
            }
        }

        private void runTask(@NotNull Computable<ListenableFuture<?>> task2) {
            try {
                this.myFuture.set(task2.compute());
            }
            catch (Throwable t) {
                this.myFuture.setException(t);
            }
        }

        public void dispose() {
        }
    }

    private static class CancellingOnHeavyOrPowerSaveListener
    implements HeavyProcessLatch.HeavyProcessListener,
    PowerSaveMode.Listener {
        @NotNull
        private final ProgressIndicator myIndicator;
        private final int myLongActivityDurationMs;
        @Nullable
        private ScheduledFuture<?> myFuture = null;

        CancellingOnHeavyOrPowerSaveListener(@NotNull Project project, @NotNull ProgressIndicator indicator, int logActivityDurationMs, @NotNull Disposable disposable) {
            this.myIndicator = indicator;
            this.myLongActivityDurationMs = logActivityDurationMs;
            HeavyProcessLatch.INSTANCE.addListener((HeavyProcessLatch.HeavyProcessListener)this, disposable);
            project.getMessageBus().connect(disposable).subscribe(PowerSaveMode.TOPIC, (Object)this);
            this.scheduleCancel();
            this.powerSaveStateChanged();
        }

        public void processStarted() {
            this.scheduleCancel();
        }

        public void processFinished() {
            this.doNotCancel();
        }

        public void powerSaveStateChanged() {
            if (PowerSaveMode.isEnabled() && this.myIndicator.isRunning()) {
                this.myIndicator.cancel();
            }
        }

        private synchronized void scheduleCancel() {
            if (HeavyProcessLatch.INSTANCE.isRunning() && this.myFuture == null) {
                this.myFuture = JobScheduler.getScheduler().schedule(() -> {
                    if (HeavyProcessLatch.INSTANCE.isRunning() && this.myIndicator.isRunning()) {
                        this.myIndicator.cancel();
                    }
                }, (long)this.myLongActivityDurationMs, TimeUnit.MILLISECONDS);
            }
        }

        private synchronized void doNotCancel() {
            if (!HeavyProcessLatch.INSTANCE.isRunning() && this.myFuture != null) {
                ScheduledFuture<?> future2 = this.myFuture;
                this.myFuture = null;
                future2.cancel(true);
            }
        }
    }
}

