/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.history.EdgeData;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.util.VcsLogUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="hashes")
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B\u0007\b\u0010\u00a2\u0006\u0002\u0010\u0002B\u0015\b\u0010\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u000e\u001a\u00020\bH\u00c6\u0003J\t\u0010\u000f\u001a\u00020\bH\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u0016J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\bH\u00d6\u0001R\u0016\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/log/history/Hashes;", "", "()V", "edgeData", "Lcom/intellij/vcs/log/history/EdgeData;", "Lcom/intellij/vcs/log/CommitId;", "(Lcom/intellij/vcs/log/history/EdgeData;)V", "parentHash", "", "childHash", "(Ljava/lang/String;Ljava/lang/String;)V", "getChildHash", "()Ljava/lang/String;", "getParentHash", "component1", "component2", "copy", "equals", "", "other", "getCommitIds", "rootFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "hashCode", "", "toString", "intellij.platform.vcs.log.impl"})
public final class Hashes {
    @Attribute(value="parentHash")
    @NotNull
    private final String parentHash;
    @Attribute(value="childHash")
    @NotNull
    private final String childHash;

    @Nullable
    public final EdgeData<CommitId> getCommitIds(@NotNull VirtualFile rootFile2) {
        if (!VcsLogUtil.HASH_REGEX.matcher(this.parentHash).matches() || !VcsLogUtil.HASH_REGEX.matcher(this.childHash).matches()) {
            return null;
        }
        return new EdgeData<CommitId>(new CommitId(HashImpl.build(this.parentHash), rootFile2), new CommitId(HashImpl.build(this.childHash), rootFile2));
    }

    @NotNull
    public final String getParentHash() {
        return this.parentHash;
    }

    @NotNull
    public final String getChildHash() {
        return this.childHash;
    }

    public Hashes(@NotNull String parentHash, @NotNull String childHash) {
        this.parentHash = parentHash;
        this.childHash = childHash;
    }

    public Hashes() {
        this("", "");
    }

    public Hashes(@NotNull EdgeData<CommitId> edgeData) {
        this(edgeData.getParent().getHash().asString(), edgeData.getChild().getHash().asString());
    }

    @NotNull
    public final String component1() {
        return this.parentHash;
    }

    @NotNull
    public final String component2() {
        return this.childHash;
    }

    @NotNull
    public final Hashes copy(@NotNull String parentHash, @NotNull String childHash) {
        return new Hashes(parentHash, childHash);
    }

    public static /* synthetic */ Hashes copy$default(Hashes hashes, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = hashes.parentHash;
        }
        if ((n & 2) != 0) {
            string2 = hashes.childHash;
        }
        return hashes.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "Hashes(parentHash=" + this.parentHash + ", childHash=" + this.childHash + ")";
    }

    public int hashCode() {
        String string = this.parentHash;
        String string2 = this.childHash;
        return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Hashes)) break block3;
                Hashes hashes = (Hashes)object;
                if (!Intrinsics.areEqual((Object)this.parentHash, (Object)hashes.parentHash) || !Intrinsics.areEqual((Object)this.childHash, (Object)hashes.childHash)) break block3;
            }
            return true;
        }
        return false;
    }
}

