/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.navigation.History;
import com.intellij.util.Consumer;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.history.FileHistoryColorManager;
import com.intellij.vcs.log.history.FileHistoryEditorDiffPreview;
import com.intellij.vcs.log.history.FileHistoryFilterUi;
import com.intellij.vcs.log.history.FileHistoryModel;
import com.intellij.vcs.log.history.FileHistoryPanel;
import com.intellij.vcs.log.history.FileHistoryUiProperties;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogColumn;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.awt.Color;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryUi
extends AbstractVcsLogUi {
    @NotNull
    private static final String HELP_ID = "reference.versionControl.toolwindow.history";
    @NotNull
    private final FilePath myPath;
    @NotNull
    private final VirtualFile myRoot;
    @Nullable
    private final Hash myRevision;
    @NotNull
    private final FileHistoryModel myFileHistoryModel;
    @NotNull
    private final FileHistoryUiProperties myUiProperties;
    @NotNull
    private final FileHistoryFilterUi myFilterUi;
    @NotNull
    private final FileHistoryPanel myFileHistoryPanel;
    @NotNull
    private final Set<String> myHighlighterIds;
    @NotNull
    private final MyPropertiesChangeListener myPropertiesChangeListener;
    @NotNull
    private final History myHistory;

    public FileHistoryUi(@NotNull VcsLogData logData, @NotNull FileHistoryUiProperties uiProperties, @NotNull VisiblePackRefresher refresher, @NotNull FilePath path2, @Nullable Hash revision, @NotNull VirtualFile root) {
        super(FileHistoryUi.getFileHistoryLogId(path2, revision), logData, new FileHistoryColorManager(root, path2), refresher);
        assert (!path2.isDirectory());
        this.myPath = path2;
        this.myRoot = root;
        this.myRevision = revision;
        this.myUiProperties = uiProperties;
        this.myFileHistoryModel = new FileHistoryModel(logData, Objects.requireNonNull(logData.getLogProvider(root).getDiffHandler()), root){

            @Override
            @NotNull
            protected VisiblePack getVisiblePack() {
                return FileHistoryUi.this.myVisiblePack;
            }
        };
        this.myFilterUi = new FileHistoryFilterUi(path2, revision, root, uiProperties);
        this.myFileHistoryPanel = new FileHistoryPanel(this, this.myFileHistoryModel, logData, path2, !VcsLogUiUtil.isDiffPreviewInEditor(), this);
        if (VcsLogUiUtil.isDiffPreviewInEditor()) {
            new FileHistoryEditorDiffPreview(logData.getProject(), this.myUiProperties, this.myFileHistoryPanel);
        }
        this.myHighlighterIds = this.myRevision == null ? ContainerUtil.newHashSet((Object[])new String[]{"MY_COMMITS", "CURRENT_BRANCH"}) : Collections.singleton("MY_COMMITS");
        VcsLogUiUtil.installHighlighters(this, f -> this.isHighlighterEnabled(f.getId()));
        if (this.myRevision != null) {
            this.getTable().addHighlighter(new RevisionHistoryHighlighter(this.myLogData.getStorage(), this.myRevision, this.myRoot));
        }
        this.myPropertiesChangeListener = new MyPropertiesChangeListener();
        this.myUiProperties.addChangeListener(this.myPropertiesChangeListener);
        this.myHistory = VcsLogUiUtil.installNavigationHistory(this);
    }

    @NotNull
    public static String getFileHistoryLogId(@NotNull FilePath path2, @Nullable Hash revision) {
        return path2.getPath() + (revision == null ? "" : revision.asString());
    }

    @Override
    public void setVisiblePack(@NotNull VisiblePack pack) {
        super.setVisiblePack(pack);
        if (pack.canRequestMore()) {
            this.requestMore(EmptyRunnable.INSTANCE);
        }
    }

    @Nullable
    public VcsFileRevision createRevision(@Nullable VcsCommitMetadata commit) {
        return this.myFileHistoryModel.createRevision(commit);
    }

    @Nullable
    public FilePath getPathInCommit(@NotNull Hash hash) {
        return this.myFileHistoryModel.getPathInCommit(hash);
    }

    @Override
    protected <T> void handleCommitNotFound(@NotNull T commitId, boolean commitExists, @NotNull PairFunction<GraphTableModel, T, Integer> rowGetter) {
        if (!commitExists) {
            super.handleCommitNotFound(commitId, false, rowGetter);
            return;
        }
        if (this.getFilterUi().getFilters().get(VcsLogFilterCollection.BRANCH_FILTER) != null) {
            String text2 = VcsLogBundle.message((String)"file.history.commit.not.found.in.branch", (Object[])new Object[]{FileHistoryUi.getCommitPresentation(commitId), this.myPath.getName()});
            this.showWarningWithLink(text2, VcsLogBundle.message((String)"file.history.commit.not.found.view.and.show.all.branches.link", (Object[])new Object[0]), () -> {
                this.myUiProperties.set(FileHistoryUiProperties.SHOW_ALL_BRANCHES, true);
                this.invokeOnChange(() -> this.jumpTo(commitId, rowGetter, (SettableFuture<? super Boolean>)SettableFuture.create(), false));
            });
        } else {
            String text3 = VcsLogBundle.message((String)"file.history.commit.not.found", (Object[])new Object[]{FileHistoryUi.getCommitPresentation(commitId), this.myPath.getName()});
            this.showWarningWithLink(text3, VcsLogBundle.message((String)"file.history.commit.not.found.view.in.log.link", (Object[])new Object[0]), () -> VcsLogContentUtil.runInMainLog(this.myProject, (Consumer<? super MainVcsLogUi>)((Consumer)ui2 -> {
                if (commitId instanceof Hash) {
                    ui2.jumpToCommit((Hash)commitId, this.myRoot);
                } else if (commitId instanceof String) {
                    ui2.jumpToHash((String)commitId);
                }
            })));
        }
    }

    public boolean matches(@NotNull FilePath targetPath, @Nullable Hash targetRevision) {
        return this.myPath.equals(targetPath) && Objects.equals(this.myRevision, targetRevision);
    }

    @NotNull
    public VcsLogFilterUi getFilterUi() {
        return this.myFilterUi;
    }

    public boolean isHighlighterEnabled(@NotNull String id) {
        return this.myHighlighterIds.contains(id);
    }

    @Override
    protected void onVisiblePackUpdated(boolean permGraphChanged) {
        ((FileHistoryColorManager)this.myColorManager).update(this.myVisiblePack);
        this.myFileHistoryPanel.updateDataPack(this.myVisiblePack, permGraphChanged);
        this.myFileHistoryPanel.getGraphTable().rootColumnUpdated();
    }

    @Override
    @NotNull
    public VcsLogGraphTable getTable() {
        return this.myFileHistoryPanel.getGraphTable();
    }

    @Override
    @NotNull
    public JComponent getMainComponent() {
        return this.myFileHistoryPanel;
    }

    @Override
    @Nullable
    public String getHelpId() {
        return HELP_ID;
    }

    private void updateFilter() {
        this.myRefresher.onFiltersChange(this.myFilterUi.getFilters());
    }

    @Override
    @NotNull
    public FileHistoryUiProperties getProperties() {
        return this.myUiProperties;
    }

    @Override
    @Nullable
    public History getNavigationHistory() {
        return this.myHistory;
    }

    @Override
    public void dispose() {
        this.myUiProperties.removeChangeListener(this.myPropertiesChangeListener);
        super.dispose();
    }

    private static class RevisionHistoryHighlighter
    implements VcsLogHighlighter {
        @NotNull
        private final JBColor myBgColor = JBColor.namedColor((String)"VersionControl.FileHistory.Commit.selectedBranchBackground", (Color)new JBColor(new Color(0xFFFEE4), new Color(4802879)));
        @NotNull
        private final VcsLogStorage myStorage;
        @NotNull
        private final Hash myRevision;
        @NotNull
        private final VirtualFile myRoot;
        @Nullable
        private Condition<Integer> myCondition;
        @NotNull
        private VcsLogDataPack myVisiblePack = VisiblePack.EMPTY;

        RevisionHistoryHighlighter(@NotNull VcsLogStorage storage, @NotNull Hash revision, @NotNull VirtualFile root) {
            this.myStorage = storage;
            this.myRevision = revision;
            this.myRoot = root;
        }

        @NotNull
        public VcsLogHighlighter.VcsCommitStyle getStyle(int commitId, @NotNull VcsShortCommitDetails commitDetails2, boolean isSelected) {
            if (isSelected) {
                return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            }
            if (this.myCondition == null) {
                this.myCondition = this.getCondition();
            }
            if (this.myCondition.value((Object)commitId)) {
                return VcsCommitStyleFactory.background((Color)this.myBgColor);
            }
            return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        }

        @NotNull
        private Condition<Integer> getCondition() {
            if (!(this.myVisiblePack instanceof VisiblePack)) {
                return Conditions.alwaysFalse();
            }
            DataPackBase dataPack = ((VisiblePack)this.myVisiblePack).getDataPack();
            if (!(dataPack instanceof DataPack)) {
                return Conditions.alwaysFalse();
            }
            Set<Integer> heads = Collections.singleton(this.myStorage.getCommitIndex(this.myRevision, this.myRoot));
            return ((DataPack)dataPack).getPermanentGraph().getContainedInBranchCondition(heads);
        }

        public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
            this.myVisiblePack = dataPack;
            this.myCondition = this.myVisiblePack.getFilters().get(VcsLogFilterCollection.REVISION_FILTER) != null ? Conditions.alwaysFalse() : null;
        }
    }

    private class MyPropertiesChangeListener
    implements VcsLogUiProperties.PropertiesChangeListener {
        private MyPropertiesChangeListener() {
        }

        @Override
        public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
            if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
                FileHistoryUi.this.myFileHistoryPanel.showDetails(FileHistoryUi.this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
            } else if (FileHistoryUiProperties.SHOW_ALL_BRANCHES.equals(property)) {
                FileHistoryUi.this.updateFilter();
            } else if (CommonUiProperties.COLUMN_ORDER.equals(property)) {
                FileHistoryUi.this.getTable().onColumnOrderSettingChanged();
            } else if (property instanceof CommonUiProperties.TableColumnProperty) {
                FileHistoryUi.this.getTable().forceReLayout(((CommonUiProperties.TableColumnProperty)property).getColumn());
            } else if (CommonUiProperties.SHOW_ROOT_NAMES.equals(property)) {
                FileHistoryUi.this.getTable().rootColumnUpdated();
            } else if (property.equals(CommonUiProperties.PREFER_COMMIT_DATE) && FileHistoryUi.this.getTable().getTableColumn(VcsLogColumn.DATE) != null) {
                FileHistoryUi.this.getTable().repaint();
            }
        }
    }
}

