/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryPaths;
import com.intellij.vcs.log.history.FileHistoryUtil;
import com.intellij.vcs.log.history.VcsLogFileRevision;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileHistoryModel {
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogDiffHandler myDiffHandler;
    @NotNull
    private final VirtualFile myRoot;

    public FileHistoryModel(@NotNull VcsLogData data, @NotNull VcsLogDiffHandler handler, @NotNull VirtualFile root) {
        this.myLogData = data;
        this.myDiffHandler = handler;
        this.myRoot = root;
    }

    @NotNull
    protected abstract VisiblePack getVisiblePack();

    @NotNull
    VcsLogDiffHandler getDiffHandler() {
        return this.myDiffHandler;
    }

    @Nullable
    public VcsFileRevision createRevision(@Nullable VcsCommitMetadata commit) {
        if (commit == null) {
            return null;
        }
        if (this.isFileDeletedInCommit((Hash)commit.getId())) {
            return VcsFileRevision.NULL;
        }
        FilePath path2 = this.getPathInCommit((Hash)commit.getId());
        if (path2 == null) {
            return null;
        }
        return new VcsLogFileRevision(commit, this.myDiffHandler.createContentRevision(path2, (Hash)commit.getId()), path2, false);
    }

    @Nullable
    public FilePath getPathInCommit(@NotNull Hash hash) {
        int commitIndex = this.myLogData.getStorage().getCommitIndex(hash, this.myRoot);
        return FileHistoryPaths.filePath(this.getVisiblePack(), commitIndex);
    }

    private boolean isFileDeletedInCommit(@NotNull Hash hash) {
        int commitIndex = this.myLogData.getStorage().getCommitIndex(hash, this.myRoot);
        return FileHistoryPaths.isDeletedInCommit(this.getVisiblePack(), commitIndex);
    }

    @Nullable
    public Change getSelectedChange(int @NotNull [] rows) {
        if (rows.length == 0) {
            return null;
        }
        int row2 = rows[0];
        List<Integer> parentRows = rows.length == 1 ? this.getVisiblePack().getVisibleGraph().getRowInfo(row2).getAdjacentRows(true) : Collections.singletonList(rows[rows.length - 1]);
        return FileHistoryUtil.createChangeToParents(row2, parentRows, this.getVisiblePack(), this.myDiffHandler, this.myLogData);
    }
}

