/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.util.BooleanFunction;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.UpdatableIntToIntMap;
import com.intellij.vcs.log.graph.utils.impl.AbstractIntToIntMap;
import com.intellij.vcs.log.graph.utils.impl.BooleanFunctionFlags;
import com.intellij.vcs.log.graph.utils.impl.IDIntToIntMap;
import org.jetbrains.annotations.NotNull;

public class ListIntToIntMap
extends AbstractIntToIntMap
implements UpdatableIntToIntMap {
    public static final int DEFAULT_BLOCK_SIZE = 30;
    @NotNull
    final Flags myVisibility;
    private final int myLongSize;
    private final int myBlockSize;
    private final int[] mySubSumOfBlocks;

    @NotNull
    public static UpdatableIntToIntMap newInstance(@NotNull BooleanFunction<Integer> thisIsVisible, int longSize) {
        return ListIntToIntMap.newInstance(new BooleanFunctionFlags(thisIsVisible, longSize));
    }

    @NotNull
    public static UpdatableIntToIntMap newInstance(@NotNull Flags visibleNodes) {
        return ListIntToIntMap.newInstance(visibleNodes, 30);
    }

    @NotNull
    public static UpdatableIntToIntMap newInstance(@NotNull Flags visibility, int blockSize) {
        int longSize = visibility.size();
        if (longSize < 0) {
            throw new NegativeArraySizeException("size < 0: " + longSize);
        }
        if (longSize == 0) {
            return IDIntToIntMap.EMPTY;
        }
        int sumSize = (longSize - 1) / blockSize + 1;
        ListIntToIntMap listIntToIntMap = new ListIntToIntMap(visibility, longSize, blockSize, new int[sumSize]);
        listIntToIntMap.update(0, longSize - 1);
        return listIntToIntMap;
    }

    private ListIntToIntMap(@NotNull Flags visibility, int longSize, int blockSize, int[] subSumOfBlocks) {
        this.myLongSize = longSize;
        this.myVisibility = visibility;
        this.myBlockSize = blockSize;
        this.mySubSumOfBlocks = subSumOfBlocks;
    }

    @Override
    public int shortSize() {
        return this.mySubSumOfBlocks[this.mySubSumOfBlocks.length - 1];
    }

    @Override
    public int longSize() {
        return this.myLongSize;
    }

    private int getRelevantSumIndex(int longIndex) {
        return longIndex / this.myBlockSize;
    }

    @Override
    public int getLongIndex(int shortIndex) {
        this.checkShortIndex(shortIndex);
        int blockIndex = ListIntToIntMap.lastInsertionPoint(this.mySubSumOfBlocks, shortIndex);
        int prefVisibleCount = 0;
        if (blockIndex > 0) {
            prefVisibleCount = this.mySubSumOfBlocks[blockIndex - 1];
        }
        for (int longIndex = blockIndex * this.myBlockSize; longIndex < this.myLongSize; ++longIndex) {
            if (this.myVisibility.get(longIndex)) {
                ++prefVisibleCount;
            }
            if (prefVisibleCount <= shortIndex) continue;
            return longIndex;
        }
        throw new IllegalAccessError("This should never happen!");
    }

    @Override
    public int getShortIndex(int longIndex) {
        this.checkLongIndex(longIndex);
        int blockIndex = this.getRelevantSumIndex(longIndex);
        int countVisible = this.calculateSumForBlock(blockIndex, longIndex);
        if (countVisible > 0) {
            return countVisible - 1;
        }
        return 0;
    }

    private int calculateSumForBlock(int blockIndex, int lastLongIndex) {
        int sum = 0;
        if (blockIndex > 0) {
            sum = this.mySubSumOfBlocks[blockIndex - 1];
        }
        for (int longIndex = blockIndex * this.myBlockSize; longIndex <= lastLongIndex; ++longIndex) {
            if (!this.myVisibility.get(longIndex)) continue;
            ++sum;
        }
        return sum;
    }

    private void updateSumWithCorrectPrevious(int blockIndex) {
        int endIndex = Math.min(this.myLongSize, (blockIndex + 1) * this.myBlockSize);
        this.mySubSumOfBlocks[blockIndex] = this.calculateSumForBlock(blockIndex, endIndex - 1);
    }

    @Override
    public void update(int startLongIndex, int endLongIndex) {
        this.checkUpdateParameters(startLongIndex, endLongIndex);
        int startSumIndex = this.getRelevantSumIndex(startLongIndex);
        int endSumIndex = this.getRelevantSumIndex(endLongIndex);
        int prevEndSum = this.mySubSumOfBlocks[endSumIndex];
        for (int blockIndex = startSumIndex; blockIndex <= endSumIndex; ++blockIndex) {
            this.updateSumWithCorrectPrevious(blockIndex);
        }
        int sumDelta = this.mySubSumOfBlocks[endSumIndex] - prevEndSum;
        int blockIndex = endSumIndex + 1;
        while (blockIndex < this.mySubSumOfBlocks.length) {
            int n = blockIndex++;
            this.mySubSumOfBlocks[n] = this.mySubSumOfBlocks[n] + sumDelta;
        }
    }

    private static int lastInsertionPoint(int[] array, int key) {
        int l = 0;
        int u = array.length - 1;
        while (u > l) {
            int middle = (l + u) / 2;
            if (array[middle] <= key) {
                l = middle + 1;
                continue;
            }
            u = middle;
        }
        assert (l == u);
        return l;
    }
}

