/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.IntList;
import org.jetbrains.annotations.NotNull;

final class ByteArrayUtils {
    private static final int BYTE_OFFSET = 8;
    private static final int BYTE_MASK = 255;

    ByteArrayUtils() {
    }

    public static int countBytesAfterCompression(@NotNull IntList deltaList) {
        int count = 0;
        for (int i = 0; i < deltaList.size(); ++i) {
            count += ByteArrayUtils.sizeOf(deltaList.get(i));
        }
        return count;
    }

    public static int sizeOf(int value) {
        if (value < 0) {
            value ^= 0xFFFFFFFF;
        }
        value >>= 7;
        for (int i = 1; i < 4; ++i) {
            if (value == 0) {
                return i;
            }
            value >>= 8;
        }
        return 4;
    }

    public static void writeDelta(int startIndex, int value, int sizeOf, byte[] bytes) {
        for (int i = sizeOf - 1; i >= 0; --i) {
            bytes[startIndex + i] = (byte)value;
            value >>= 8;
        }
    }

    public static int readDelta(int startIndex, int sizeOf, byte[] bytes) {
        int i;
        boolean isNegative;
        int result2 = 0;
        boolean bl = isNegative = bytes[startIndex] < 0;
        if (isNegative) {
            for (i = 0; i < 4 - sizeOf; ++i) {
                result2 <<= 8;
                result2 |= 0xFF;
            }
        }
        for (i = startIndex; i < startIndex + sizeOf; ++i) {
            result2 <<= 8;
            result2 |= bytes[i] & 0xFF;
        }
        return result2;
    }

    public static int groundPointCount(int arraySize, int blockSize) {
        if (arraySize == 0) {
            return 1;
        }
        return (arraySize - 1) / blockSize + 1;
    }
}

