/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.utils.BfsWalk;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u0016J\u001c\u0010\u0017\u001a\u00020\u00182\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00030\u00030\u000b\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/vcs/log/graph/utils/BfsWalk;", "", "start", "", "graph", "Lcom/intellij/vcs/log/graph/api/LiteLinearGraph;", "(ILcom/intellij/vcs/log/graph/api/LiteLinearGraph;)V", "visited", "Lcom/intellij/vcs/log/graph/utils/Flags;", "(ILcom/intellij/vcs/log/graph/api/LiteLinearGraph;Lcom/intellij/vcs/log/graph/utils/Flags;)V", "queue", "Ljava/util/LinkedList;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getStart", "()I", "currentNodes", "", "isFinished", "", "step", "consumer", "Lkotlin/Function1;", "walk", "", "intellij.platform.vcs.log.graph.impl"})
public final class BfsWalk {
    private final LinkedList<Integer> queue;
    private final int start;
    private final LiteLinearGraph graph;
    private final Flags visited;

    public final boolean isFinished() {
        return this.queue.isEmpty();
    }

    @NotNull
    public final List<Integer> currentNodes() {
        return this.queue;
    }

    @NotNull
    public final List<Integer> step(@NotNull Function1<? super Integer, Boolean> consumer) {
        while (!this.queue.isEmpty()) {
            Integer node = this.queue.poll();
            if (this.visited.get(node)) continue;
            this.visited.set(node, true);
            if (!((Boolean)consumer.invoke((Object)node)).booleanValue()) {
                return CollectionsKt.emptyList();
            }
            List next = CollectionsKt.sorted((Iterable)this.graph.getNodes(node, LiteLinearGraph.NodeFilter.DOWN));
            this.queue.addAll(next);
            return next;
        }
        return CollectionsKt.emptyList();
    }

    public static /* synthetic */ List step$default(BfsWalk bfsWalk, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = step.1.INSTANCE;
        }
        return bfsWalk.step((Function1<? super Integer, Boolean>)function1);
    }

    public final void walk(@NotNull Function1<? super Integer, Boolean> consumer) {
        while (!this.isFinished()) {
            this.step(consumer);
        }
    }

    public static /* synthetic */ void walk$default(BfsWalk bfsWalk, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = walk.1.INSTANCE;
        }
        bfsWalk.walk((Function1<? super Integer, Boolean>)function1);
    }

    public final int getStart() {
        return this.start;
    }

    public BfsWalk(int start2, @NotNull LiteLinearGraph graph, @NotNull Flags visited) {
        this.start = start2;
        this.graph = graph;
        this.visited = visited;
        this.queue = ContainerUtil.newLinkedList((Object[])new Integer[]{this.start});
    }

    public BfsWalk(int start2, @NotNull LiteLinearGraph graph) {
        this(start2, graph, new BitSetFlags(graph.nodesCount()));
    }
}

