/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.util.SmartList;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermanentLinearGraphImpl
implements LinearGraph {
    @NotNull
    private final Flags mySimpleNodes;
    @NotNull
    private final IntList myNodeToEdgeIndex;
    @NotNull
    private final IntList myLongEdges;

    PermanentLinearGraphImpl(@NotNull Flags simpleNodes, int[] nodeToEdgeIndex, int[] longEdges) {
        this.mySimpleNodes = simpleNodes;
        this.myNodeToEdgeIndex = CompressedIntList.newInstance(nodeToEdgeIndex);
        this.myLongEdges = CompressedIntList.newInstance(longEdges);
    }

    @Override
    public int nodesCount() {
        return this.mySimpleNodes.size();
    }

    @Override
    @NotNull
    public List<GraphEdge> getAdjacentEdges(int nodeIndex, @NotNull EdgeFilter filter) {
        boolean hasUpSimpleEdge;
        SmartList result2 = new SmartList();
        boolean bl = hasUpSimpleEdge = nodeIndex != 0 && this.mySimpleNodes.get(nodeIndex - 1);
        if (hasUpSimpleEdge && filter.upNormal) {
            result2.add(new GraphEdge(nodeIndex - 1, nodeIndex, null, GraphEdgeType.USUAL));
        }
        for (int i = this.myNodeToEdgeIndex.get(nodeIndex); i < this.myNodeToEdgeIndex.get(nodeIndex + 1); ++i) {
            int adjacentNode = this.myLongEdges.get(i);
            if (adjacentNode < 0 && filter.special) {
                result2.add(GraphEdge.createEdgeWithTargetId(nodeIndex, adjacentNode, GraphEdgeType.NOT_LOAD_COMMIT));
            }
            if (adjacentNode < 0) continue;
            if (nodeIndex > adjacentNode && filter.upNormal) {
                result2.add(new GraphEdge(adjacentNode, nodeIndex, null, GraphEdgeType.USUAL));
            }
            if (nodeIndex >= adjacentNode || !filter.downNormal) continue;
            result2.add(new GraphEdge(nodeIndex, adjacentNode, null, GraphEdgeType.USUAL));
        }
        if (this.mySimpleNodes.get(nodeIndex) && filter.downNormal) {
            result2.add(new GraphEdge(nodeIndex, nodeIndex + 1, null, GraphEdgeType.USUAL));
        }
        return result2;
    }

    @Override
    @NotNull
    public GraphNode getGraphNode(int nodeIndex) {
        return new GraphNode(nodeIndex);
    }

    @Override
    public int getNodeId(int nodeIndex) {
        assert (nodeIndex >= 0 && nodeIndex < this.nodesCount()) : "Bad nodeIndex: " + nodeIndex;
        return nodeIndex;
    }

    @Override
    @Nullable
    public Integer getNodeIndex(int nodeId) {
        if (nodeId >= 0 && nodeId < this.nodesCount()) {
            return nodeId;
        }
        return null;
    }
}

