/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.NotNullFunction;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.api.printer.PrintElementManager;
import com.intellij.vcs.log.graph.impl.print.ColorGetterByLayoutIndex;
import com.intellij.vcs.log.graph.impl.print.GraphElementComparatorByLayoutIndex;
import com.intellij.vcs.log.graph.impl.print.elements.PrintElementWithGraphElement;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PrintElementManagerImpl
implements PrintElementManager {
    @NotNull
    private final Comparator<GraphElement> myGraphElementComparator;
    @NotNull
    private final ColorGetterByLayoutIndex myColorGetter;
    @NotNull
    private final LinearGraph myLinearGraph;
    @NotNull
    private Selection mySelection = new Selection(Collections.emptySet());

    PrintElementManagerImpl(@NotNull LinearGraph linearGraph, @NotNull PermanentGraphInfo myPermanentGraph, @NotNull GraphColorManager colorManager) {
        this.myLinearGraph = linearGraph;
        this.myColorGetter = new ColorGetterByLayoutIndex(linearGraph, myPermanentGraph, colorManager);
        this.myGraphElementComparator = new GraphElementComparatorByLayoutIndex((NotNullFunction<? super Integer, Integer>)((NotNullFunction)nodeIndex -> {
            int nodeId = linearGraph.getNodeId((int)nodeIndex);
            if (nodeId < 0) {
                return nodeId;
            }
            return myPermanentGraph.getPermanentGraphLayout().getLayoutIndex(nodeId);
        }));
    }

    @Override
    public boolean isSelected(@NotNull PrintElementWithGraphElement printElement) {
        return this.mySelection.isSelected(printElement);
    }

    boolean setSelectedElement(@NotNull PrintElementWithGraphElement printElement) {
        return this.setSelection(new Selection(printElement));
    }

    boolean setSelectedElements(@NotNull Set<Integer> selectedNodeId) {
        return this.setSelection(new Selection(selectedNodeId));
    }

    private boolean setSelection(@NotNull Selection newSelection) {
        if (newSelection.equals(this.mySelection)) {
            return false;
        }
        this.mySelection = newSelection;
        return true;
    }

    @Override
    public int getColorId(@NotNull GraphElement element) {
        return this.myColorGetter.getColorId(element);
    }

    @Override
    @NotNull
    public Comparator<GraphElement> getGraphElementComparator() {
        return this.myGraphElementComparator;
    }

    public class Selection {
        @Nullable
        private final PrintElementWithGraphElement mySelectedPrintElement;
        @NotNull
        private final Set<Integer> mySelectedNodeIds;

        public Selection(Set<Integer> selectedNodeId) {
            this(null, selectedNodeId);
        }

        public Selection(PrintElementWithGraphElement printElement) {
            this(printElement, Collections.emptySet());
        }

        private Selection(@NotNull PrintElementWithGraphElement printElement, Set<Integer> nodeIds) {
            this.mySelectedPrintElement = printElement;
            this.mySelectedNodeIds = nodeIds;
        }

        public boolean isSelected(@NotNull PrintElementWithGraphElement printElement) {
            if (printElement.equals(this.mySelectedPrintElement)) {
                return true;
            }
            GraphElement graphElement = printElement.getGraphElement();
            if (graphElement instanceof GraphNode) {
                int nodeId = PrintElementManagerImpl.this.myLinearGraph.getNodeId(((GraphNode)graphElement).getNodeIndex());
                return this.mySelectedNodeIds.contains(nodeId);
            }
            if (graphElement instanceof GraphEdge) {
                GraphEdge edge = (GraphEdge)graphElement;
                boolean selected = edge.getTargetId() == null || this.mySelectedNodeIds.contains(edge.getTargetId());
                selected &= edge.getUpNodeIndex() == null || this.mySelectedNodeIds.contains(PrintElementManagerImpl.this.myLinearGraph.getNodeId(edge.getUpNodeIndex()));
                return selected &= edge.getDownNodeIndex() == null || this.mySelectedNodeIds.contains(PrintElementManagerImpl.this.myLinearGraph.getNodeId(edge.getDownNodeIndex()));
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Selection selection = (Selection)o;
            return Objects.equals(this.mySelectedPrintElement, selection.mySelectedPrintElement) && Comparing.haveEqualElements(this.mySelectedNodeIds, selection.mySelectedNodeIds);
        }

        public int hashCode() {
            return 31 * Objects.hashCode(this.mySelectedPrintElement) + Comparing.unorderedHashcode(this.mySelectedNodeIds);
        }
    }
}

