/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.impl.facade.GraphChanges;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class GraphChangesUtil {
    public static final GraphChanges<Integer> SOME_CHANGES = new GraphChanges<Integer>(){

        @Override
        @NotNull
        public Collection<GraphChanges.Node<Integer>> getChangedNodes() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public Collection<GraphChanges.Edge<Integer>> getChangedEdges() {
            return Collections.emptyList();
        }
    };

    public static GraphChanges.EdgeImpl<Integer> edgeChanged(@NotNull GraphEdge edge, @NotNull LinearGraph graph, boolean removed) {
        Integer up = null;
        Integer down = null;
        if (edge.getUpNodeIndex() != null) {
            up = graph.getNodeId(edge.getUpNodeIndex());
        }
        if (edge.getDownNodeIndex() != null) {
            down = graph.getNodeId(edge.getDownNodeIndex());
        }
        return new GraphChanges.EdgeImpl<Integer>(up, down, edge.getTargetId(), removed);
    }

    public static GraphChanges<Integer> edgesReplaced(Collection<GraphEdge> removedEdges, Collection<GraphEdge> addedEdges, LinearGraph delegateGraph) {
        HashSet edgeChanges = new HashSet();
        for (GraphEdge edge : removedEdges) {
            edgeChanges.add(GraphChangesUtil.edgeChanged(edge, delegateGraph, true));
        }
        for (GraphEdge edge : addedEdges) {
            edgeChanges.add(GraphChangesUtil.edgeChanged(edge, delegateGraph, false));
        }
        return new GraphChanges.GraphChangesImpl<Integer>(Collections.emptySet(), edgeChanges);
    }
}

