/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.VoidDataExternalizer;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.util.StorageId;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsLogMessagesTrigramIndex
extends VcsLogFullDetailsIndex<Void, VcsCommitMetadata> {
    private static final String TRIGRAMS = "trigrams";

    public VcsLogMessagesTrigramIndex(@NotNull StorageId storageId, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable disposableParent) throws IOException {
        super(storageId, TRIGRAMS, new TrigramMessageIndexer(), VoidDataExternalizer.INSTANCE, fatalErrorHandler, disposableParent);
    }

    @Nullable
    public IntSet getCommitsForSubstring(@NotNull CharSequence string) throws StorageException {
        MyTrigramProcessor trigramProcessor = new MyTrigramProcessor();
        TrigramBuilder.processTrigrams((CharSequence)string, (TrigramBuilder.TrigramProcessor)trigramProcessor);
        if (trigramProcessor.map.isEmpty()) {
            return null;
        }
        return this.getCommitsWithAllKeys((Collection<Integer>)trigramProcessor.map.keySet());
    }

    private static final class MyTrigramProcessor
    extends TrigramBuilder.TrigramProcessor {
        Int2ObjectMap<Void> map;

        private MyTrigramProcessor() {
        }

        public boolean consumeTrigramsCount(int count) {
            this.map = new Int2ObjectOpenHashMap(count);
            return true;
        }

        public boolean test(int value) {
            this.map.put(value, null);
            return true;
        }
    }

    public static final class TrigramMessageIndexer
    implements DataIndexer<Integer, Void, VcsCommitMetadata> {
        @NotNull
        public Map<Integer, Void> map(@NotNull VcsCommitMetadata inputData) {
            MyTrigramProcessor trigramProcessor = new MyTrigramProcessor();
            TrigramBuilder.processTrigrams((CharSequence)inputData.getFullMessage(), (TrigramBuilder.TrigramProcessor)trigramProcessor);
            return trigramProcessor.map;
        }
    }
}

