/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.InvertedIndexUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.KeyCollectionForwardIndexAccessor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.util.StorageId;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.Collection;
import java.util.function.IntConsumer;
import java.util.function.ObjIntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogFullDetailsIndex<T, D>
implements Disposable {
    protected static final String INDEX = "index";
    @NotNull
    private final MyMapReduceIndex myMapReduceIndex;
    @NotNull
    protected final StorageId myStorageId;
    @NotNull
    protected final String myName;
    @NotNull
    protected final DataIndexer<Integer, T, D> myIndexer;
    @NotNull
    private final FatalErrorHandler myFatalErrorHandler;
    private volatile boolean myDisposed = false;

    public VcsLogFullDetailsIndex(@NotNull StorageId storageId, @NotNull String name, @NotNull DataIndexer<Integer, T, D> indexer, @NotNull DataExternalizer<T> externalizer, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable disposableParent) throws IOException {
        this.myName = name;
        this.myStorageId = storageId;
        this.myIndexer = indexer;
        this.myFatalErrorHandler = fatalErrorHandler;
        this.myMapReduceIndex = this.createMapReduceIndex(externalizer);
        Disposer.register((Disposable)disposableParent, (Disposable)this);
    }

    @NotNull
    private MyMapReduceIndex createMapReduceIndex(@NotNull DataExternalizer<T> dataExternalizer) throws IOException {
        MyIndexExtension<T, D> extension = new MyIndexExtension<T, D>(this.myName, this.myIndexer, dataExternalizer, this.myStorageId.getVersion());
        Pair<ForwardIndex, ForwardIndexAccessor<Integer, T>> pair = this.createdForwardIndex();
        ForwardIndex forwardIndex = pair != null ? (ForwardIndex)pair.getFirst() : null;
        ForwardIndexAccessor forwardIndexAccessor = pair != null ? (ForwardIndexAccessor)pair.getSecond() : null;
        return new MyMapReduceIndex(extension, (IndexStorage)new MyMapIndexStorage<T>(this.myName, this.myStorageId, dataExternalizer), forwardIndex, forwardIndexAccessor);
    }

    @Nullable
    protected Pair<ForwardIndex, ForwardIndexAccessor<Integer, T>> createdForwardIndex() throws IOException {
        return null;
    }

    @NotNull
    public IntSet getCommitsWithAnyKey(@NotNull IntSet keys) throws StorageException {
        this.checkDisposed();
        IntOpenHashSet result2 = new IntOpenHashSet();
        IntIterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            int key = iterator.nextInt();
            this.iterateCommitIds(key, arg_0 -> ((IntSet)result2).add(arg_0));
        }
        return result2;
    }

    @NotNull
    public IntSet getCommitsWithAllKeys(@NotNull Collection<Integer> keys) throws StorageException {
        this.checkDisposed();
        return InvertedIndexUtil.collectInputIdsContainingAllKeys((InvertedIndex)this.myMapReduceIndex, keys, k -> {
            ProgressManager.checkCanceled();
            return true;
        }, null, null);
    }

    private void iterateCommitIds(int key, @NotNull IntConsumer consumer) throws StorageException {
        ValueContainer data = this.myMapReduceIndex.getData(key);
        data.forEach((id, value) -> {
            consumer.accept(id);
            return true;
        });
    }

    protected void iterateCommitIdsAndValues(int key, @NotNull ObjIntConsumer<? super T> consumer) throws StorageException {
        this.myMapReduceIndex.getData(key).forEach((id, value) -> {
            consumer.accept(value, id);
            return true;
        });
    }

    @Nullable
    protected Collection<Integer> getKeysForCommit(int commit) throws IOException {
        ForwardIndex forwardIndex = this.myMapReduceIndex.getForwardIndex();
        KeyCollectionForwardIndexAccessor forwardIndexAccessor = (KeyCollectionForwardIndexAccessor)this.myMapReduceIndex.getForwardIndexAccessor();
        if (forwardIndex == null || forwardIndexAccessor == null) {
            return null;
        }
        return (Collection)forwardIndexAccessor.deserializeData(forwardIndex.get(Integer.valueOf(commit)));
    }

    public void update(int commitId, @NotNull D details) {
        this.checkDisposed();
        this.myMapReduceIndex.mapInputAndPrepareUpdate(commitId, details).compute();
    }

    public void flush() throws StorageException {
        this.checkDisposed();
        this.myMapReduceIndex.flush();
    }

    public void dispose() {
        this.myDisposed = true;
        this.myMapReduceIndex.dispose();
    }

    private void checkDisposed() {
        if (this.myDisposed) {
            throw new ProcessCanceledException();
        }
    }

    private static class MyIndexExtension<T, D>
    extends IndexExtension<Integer, T, D> {
        @NotNull
        private final IndexId<Integer, T> myID;
        @NotNull
        private final DataIndexer<Integer, T, D> myIndexer;
        @NotNull
        private final DataExternalizer<T> myExternalizer;
        private final int myVersion;

        MyIndexExtension(@NotNull String name, @NotNull DataIndexer<Integer, T, D> indexer, @NotNull DataExternalizer<T> externalizer, int version) {
            this.myID = IndexId.create((String)name);
            this.myIndexer = indexer;
            this.myExternalizer = externalizer;
            this.myVersion = version;
        }

        @NotNull
        public IndexId<Integer, T> getName() {
            return this.myID;
        }

        @NotNull
        public DataIndexer<Integer, T, D> getIndexer() {
            return this.myIndexer;
        }

        @NotNull
        public KeyDescriptor<Integer> getKeyDescriptor() {
            return EnumeratorIntegerDescriptor.INSTANCE;
        }

        @NotNull
        public DataExternalizer<T> getValueExternalizer() {
            return this.myExternalizer;
        }

        public int getVersion() {
            return this.myVersion;
        }
    }

    private static class MyMapIndexStorage<T>
    extends MapIndexStorage<Integer, T> {
        MyMapIndexStorage(@NotNull String name, @NotNull StorageId storageId, @NotNull DataExternalizer<T> externalizer) throws IOException {
            super(storageId.getStorageFile(name, true), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, externalizer, 5000, false);
        }

        protected void checkCanceled() {
            ProgressManager.checkCanceled();
        }
    }

    private final class MyMapReduceIndex
    extends MapReduceIndex<Integer, T, D> {
        private MyMapReduceIndex(@NotNull MyIndexExtension<T, D> extension, @Nullable IndexStorage<Integer, T> storage, @Nullable ForwardIndex forwardIndex, ForwardIndexAccessor<Integer, T> forwardIndexAccessor) {
            super(extension, storage, forwardIndex, forwardIndexAccessor);
        }

        public void checkCanceled() {
            ProgressManager.checkCanceled();
        }

        public void requestRebuild(@NotNull Throwable ex) {
            VcsLogFullDetailsIndex.this.myFatalErrorHandler.consume((Object)this, ex);
        }
    }
}

