/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit.message;

import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.commit.message.BaseCommitMessageInspection;
import com.intellij.vcs.commit.message.CommitMessageInspectionProfile;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReformatCommitMessageAction
extends DumbAwareAction {
    public static final String NAME = "Reformat commit message";

    public ReformatCommitMessageAction() {
        super(NAME);
        this.setEnabledInModalContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        Document document = ReformatCommitMessageAction.getCommitMessage(e);
        e.getPresentation().setEnabled(project != null && document != null && ReformatCommitMessageAction.getEnabledInspections(project).anyMatch(inspection -> inspection.canReformat(project, document)));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = Objects.requireNonNull(e.getProject());
        Document document = Objects.requireNonNull(ReformatCommitMessageAction.getCommitMessage(e));
        CommandProcessor.getInstance().executeCommand(project, () -> WriteAction.run(() -> ReformatCommitMessageAction.reformat(project, document)), NAME, null);
    }

    public static void reformat(@NotNull Project project, @NotNull Document document) {
        List<BaseCommitMessageInspection> inspections = ReformatCommitMessageAction.getEnabledInspections(project).collect(Collectors.toList());
        inspections.forEach(inspection -> inspection.reformat(project, document));
    }

    @Nullable
    private static Document getCommitMessage(@NotNull AnActionEvent e) {
        CommitMessage commitMessage2 = (CommitMessage)ObjectUtils.tryCast((Object)e.getData(VcsDataKeys.COMMIT_MESSAGE_CONTROL), CommitMessage.class);
        Editor editor = commitMessage2 != null ? commitMessage2.getEditorField().getEditor() : null;
        return editor != null ? editor.getDocument() : null;
    }

    @NotNull
    private static Stream<BaseCommitMessageInspection> getEnabledInspections(@NotNull Project project) {
        return CommitMessageInspectionProfile.getInstance(project).getAllEnabledInspectionTools(project).stream().map(Tools::getTool).map(InspectionToolWrapper::getTool).filter(BaseCommitMessageInspection.class::isInstance).map(BaseCommitMessageInspection.class::cast);
    }
}

