/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.changes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.psi.search.scope.packageSet.FilteredNamedScope;
import com.intellij.ui.OffsetIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class ChangeListScope
extends FilteredNamedScope
implements WeighedItem {
    private static final Icon ICON = new OffsetIcon(AllIcons.Scope.ChangedFiles);
    static final String ALL_CHANGED_FILES_SCOPE_NAME = "All Changed Files";

    public ChangeListScope(@NotNull ChangeListManager manager) {
        super(ALL_CHANGED_FILES_SCOPE_NAME, AllIcons.Scope.ChangedFilesAll, 0, arg_0 -> ((ChangeListManager)manager).isFileAffected(arg_0));
    }

    public ChangeListScope(@NotNull ChangeListManager manager, @NotNull String name) {
        super(name, ICON, 0, file -> manager.getChangeLists(file).stream().anyMatch(list -> list.getName().equals(name)));
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ChangeListScope) {
            ChangeListScope scope2 = (ChangeListScope)((Object)object);
            return scope2.getIcon() == this.getIcon() && scope2.getName().equals(this.getName());
        }
        return false;
    }

    public String toString() {
        String string = super.toString();
        if (AllIcons.Scope.ChangedFilesAll == this.getIcon()) {
            string = string + "; ALL";
        }
        return string;
    }

    public int getWeight() {
        return AllIcons.Scope.ChangedFilesAll == this.getIcon() ? 0 : 1;
    }

    public static String getNameText() {
        return ALL_CHANGED_FILES_SCOPE_NAME;
    }
}

