/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Position;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;

public abstract class HtmlPanel
extends JEditorPane
implements HyperlinkListener {
    public HtmlPanel() {
        super("text/html", "");
        this.setEditable(false);
        this.setOpaque(false);
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.addHyperlinkListener(this);
        this.setEditorKit((EditorKit)new UIUtil.JBWordWrapHtmlEditorKit());
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        BrowserHyperlinkListener.INSTANCE.hyperlinkUpdate(e);
    }

    @Override
    public String getSelectedText() {
        Document doc = this.getDocument();
        int start2 = this.getSelectionStart();
        int end = this.getSelectionEnd();
        try {
            Position p0 = doc.createPosition(start2);
            Position p1 = doc.createPosition(end);
            StringWriter sw = new StringWriter(p1.getOffset() - p0.getOffset());
            this.getEditorKit().write(sw, doc, p0.getOffset(), p1.getOffset() - p0.getOffset());
            return StringUtil.removeHtmlTags((String)sw.toString());
        }
        catch (IOException | BadLocationException exception) {
            return super.getSelectedText();
        }
    }

    public void setBody(@NotNull String text2) {
        if (text2.isEmpty()) {
            this.setText("");
        } else {
            this.setText("<html><head>" + UIUtil.getCssFontDeclaration((Font)this.getBodyFont()) + "</head><body>" + text2 + "</body></html>");
        }
    }

    @NotNull
    protected Font getBodyFont() {
        return FontUtil.getCommitMessageFont();
    }

    @NotNull
    protected abstract String getBody();

    @Override
    public void updateUI() {
        super.updateUI();
        DefaultCaret caret = (DefaultCaret)this.getCaret();
        caret.setUpdatePolicy(1);
        this.update();
    }

    public void update() {
        this.setBody(this.getBody());
        this.customizeLinksStyle();
        this.revalidate();
        this.repaint();
    }

    private void customizeLinksStyle() {
        Document document = this.getDocument();
        if (document instanceof HTMLDocument) {
            StyleSheet styleSheet = ((HTMLDocument)document).getStyleSheet();
            String linkColor = "#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkColor());
            styleSheet.addRule("a { color: " + linkColor + "; text-decoration: none;}");
        }
    }
}

