/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.vfs;

import com.intellij.codeInsight.daemon.OutsidersPsiFileSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVcsVirtualFile
extends VirtualFile {
    protected final String myName;
    protected final String myPath;
    protected String myRevision;
    private final VirtualFile myParent;
    protected int myModificationStamp = 0;
    @NotNull
    private final VirtualFileSystem myFileSystem;

    protected AbstractVcsVirtualFile(String path2, @NotNull VirtualFileSystem fileSystem) {
        this.myFileSystem = fileSystem;
        this.myPath = path2;
        File file = new File(this.myPath);
        this.myName = file.getName();
        this.myParent = !this.isDirectory() ? new VcsVirtualFolder(file.getParent(), this, this.myFileSystem) : null;
        OutsidersPsiFileSupport.markFile((VirtualFile)this);
    }

    protected AbstractVcsVirtualFile(@Nullable VirtualFile parent, @NotNull String name, @NotNull VirtualFileSystem fileSystem) {
        this.myFileSystem = fileSystem;
        this.myPath = parent != null && !StringUtil.isEmpty((String)parent.getPath()) ? parent.getPath() + "/" + name : name;
        this.myName = name;
        this.myParent = parent;
        OutsidersPsiFileSupport.markFile((VirtualFile)this);
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.myFileSystem;
    }

    @NotNull
    public String getPath() {
        return this.myPath;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public String getPresentableName() {
        return this.getPresentableName(this.myName);
    }

    @NotNull
    String getPresentableName(@NotNull String baseName) {
        if (this.myRevision == null) {
            return baseName;
        }
        return baseName + " (" + this.myRevision + ")";
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public VirtualFile getParent() {
        return this.myParent;
    }

    public VirtualFile[] getChildren() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.byteStreamSkippingBOM((byte[])this.contentsToByteArray(), (VirtualFile)this);
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) {
        throw new RuntimeException(VcsFileSystem.getCouldNotImplementMessage());
    }

    public abstract byte @NotNull [] contentsToByteArray() throws IOException;

    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    public long getTimeStamp() {
        return this.myModificationStamp;
    }

    public long getLength() {
        try {
            return this.contentsToByteArray().length;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
        if (postRunnable != null) {
            postRunnable.run();
        }
    }

    protected void setRevision(String revision) {
        this.myRevision = revision;
    }

    protected void showLoadingContentFailedMessage(@NotNull VcsException e) {
        ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.could.not.load.virtual.file.content", (Object[])new Object[]{this.getPresentableUrl(), e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.could.not.load.content", (Object[])new Object[0]), (Icon)Messages.getInformationIcon()));
    }
}

