/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.history.ByteContent;
import com.intellij.history.Label;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowUpdatedDiffActionProvider
implements AnActionExtensionProvider {
    public boolean isActive(@NotNull AnActionEvent e) {
        return this.isVisible(e.getDataContext());
    }

    public void update(@NotNull AnActionEvent e) {
        DataContext dc = e.getDataContext();
        Presentation presentation = e.getPresentation();
        presentation.setDescription(VcsBundle.messagePointer((String)"action.presentation.ShowUpdatedDiffActionProvider.description", (Object[])new Object[0]));
        presentation.setEnabled(this.isVisible(dc) && this.isEnabled(dc));
    }

    private boolean isVisible(DataContext dc) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        return project != null && VcsDataKeys.LABEL_BEFORE.getData(dc) != null && VcsDataKeys.LABEL_AFTER.getData(dc) != null;
    }

    private boolean isEnabled(DataContext dc) {
        Iterable iterable = (Iterable)VcsDataKeys.UPDATE_VIEW_FILES_ITERABLE.getData(dc);
        return iterable != null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dc = e.getDataContext();
        if (!this.isVisible(dc) || !this.isEnabled(dc)) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        Iterable iterable = (Iterable)e.getRequiredData(VcsDataKeys.UPDATE_VIEW_FILES_ITERABLE);
        Label before = (Label)e.getRequiredData(VcsDataKeys.LABEL_BEFORE);
        Label after = (Label)e.getRequiredData(VcsDataKeys.LABEL_AFTER);
        FilePath selectedUrl = (FilePath)VcsDataKeys.UPDATE_VIEW_SELECTED_PATH.getData(dc);
        ChangeDiffRequestChain requestChain = ShowUpdatedDiffActionProvider.createDiffRequestChain(project, before, after, iterable, selectedUrl);
        DiffManager.getInstance().showDiff(project, (DiffRequestChain)requestChain, DiffDialogHints.FRAME);
    }

    public static ChangeDiffRequestChain createDiffRequestChain(@Nullable Project project, @NotNull Label before, @NotNull Label after, @NotNull Iterable<? extends Pair<FilePath, FileStatus>> iterable, @Nullable FilePath selectedPath) {
        ArrayList<MyDiffRequestProducer> requests = new ArrayList<MyDiffRequestProducer>();
        int selected = -1;
        for (Pair<FilePath, FileStatus> pair : iterable) {
            if (selected == -1 && ((FilePath)pair.first).equals(selectedPath)) {
                selected = requests.size();
            }
            requests.add(new MyDiffRequestProducer(project, before, after, (FilePath)pair.first, (FileStatus)pair.second));
        }
        if (selected == -1) {
            selected = 0;
        }
        return new ChangeDiffRequestChain(requests, selected);
    }

    private static byte @NotNull [] loadContent(@NotNull FilePath path2, @NotNull Label label) throws DiffRequestProducerException {
        ByteContent byteContent = label.getByteContent(path2.getPath());
        if (byteContent == null || byteContent.isDirectory() || byteContent.getBytes() == null) {
            throw new DiffRequestProducerException("Can't load content");
        }
        return byteContent.getBytes();
    }

    private static class MyDiffRequestProducer
    implements DiffRequestProducer,
    ChangeDiffRequestChain.Producer {
        @Nullable
        private final Project myProject;
        @NotNull
        private final Label myBefore;
        @NotNull
        private final Label myAfter;
        @NotNull
        private final FileStatus myFileStatus;
        @NotNull
        private final FilePath myFilePath;

        MyDiffRequestProducer(@Nullable Project project, @NotNull Label before, @NotNull Label after, @NotNull FilePath filePath, @NotNull FileStatus fileStatus) {
            this.myProject = project;
            this.myBefore = before;
            this.myAfter = after;
            this.myFileStatus = fileStatus;
            this.myFilePath = filePath;
        }

        @NotNull
        public String getName() {
            return this.myFilePath.getPresentableUrl();
        }

        @Override
        @NotNull
        public FilePath getFilePath() {
            return this.myFilePath;
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            return this.myFileStatus;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            try {
                EmptyContent content2;
                EmptyContent content1;
                DiffContentFactoryEx contentFactory = DiffContentFactoryEx.getInstanceEx();
                if (FileStatus.ADDED.equals(this.myFileStatus)) {
                    content1 = contentFactory.createEmpty();
                } else {
                    byte[] bytes1 = ShowUpdatedDiffActionProvider.loadContent(this.myFilePath, this.myBefore);
                    content1 = contentFactory.createFromBytes(this.myProject, bytes1, this.myFilePath);
                }
                if (FileStatus.DELETED.equals(this.myFileStatus)) {
                    content2 = contentFactory.createEmpty();
                } else {
                    byte[] bytes2 = ShowUpdatedDiffActionProvider.loadContent(this.myFilePath, this.myAfter);
                    content2 = contentFactory.createFromBytes(this.myProject, bytes2, this.myFilePath);
                }
                String title2 = DiffRequestFactoryImpl.getContentTitle((FilePath)this.myFilePath);
                return new SimpleDiffRequest(title2, (DiffContent)content1, (DiffContent)content2, "Before update", "After update");
            }
            catch (IOException e) {
                throw new DiffRequestProducerException("Can't load content", (Throwable)e);
            }
        }
    }
}

