/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectReloadState;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfo;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="RestoreUpdateTree", storages={@Storage(value="$CACHE_FILE$"), @Storage(value="$WORKSPACE_FILE$", deprecated=true)})
@Service
public final class RestoreUpdateTree
implements PersistentStateComponent<Element> {
    private UpdateInfo myUpdateInfo;

    public static RestoreUpdateTree getInstance(@NotNull Project project) {
        return (RestoreUpdateTree)project.getService(RestoreUpdateTree.class);
    }

    @NotNull
    public Element getState() {
        Element element = new Element("state");
        if (this.myUpdateInfo != null && !this.myUpdateInfo.isEmpty()) {
            this.myUpdateInfo.writeExternal(element);
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        UpdateInfo updateInfo = new UpdateInfo();
        updateInfo.readExternal(state);
        this.myUpdateInfo = updateInfo.isEmpty() ? null : updateInfo;
    }

    public void registerUpdateInformation(UpdatedFiles updatedFiles, ActionInfo actionInfo) {
        this.myUpdateInfo = new UpdateInfo(updatedFiles, actionInfo);
    }

    static final class MyStartUpActivity
    implements StartupActivity.DumbAware {
        MyStartUpActivity() {
        }

        public void runActivity(@NotNull Project project) {
            ActionInfo actionInfo;
            RestoreUpdateTree instance = RestoreUpdateTree.getInstance(project);
            UpdateInfo updateInfo = instance.myUpdateInfo;
            if (updateInfo != null && !updateInfo.isEmpty() && ProjectReloadState.getInstance((Project)project).isAfterAutomaticReload() && (actionInfo = updateInfo.getActionInfo()) != null) {
                ProjectLevelVcsManagerEx projectLevelVcsManager = ProjectLevelVcsManagerEx.getInstanceEx(project);
                projectLevelVcsManager.showUpdateProjectInfo(updateInfo.getFileInformation(), VcsBundle.message((String)"action.display.name.update", (Object[])new Object[0]), actionInfo, false);
                CommittedChangesCache.getInstance(project).refreshIncomingChangesAsync();
            }
            instance.myUpdateInfo = null;
        }
    }
}

