/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.update.AbstractTreeNode;
import com.intellij.openapi.vcs.update.DirectoryTreeNode;
import com.intellij.openapi.vcs.update.FileOrDirectoryTreeNode;
import com.intellij.openapi.vcs.update.FileTreeNode;
import com.intellij.openapi.vcs.update.GroupByPackages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupTreeNode
extends AbstractTreeNode
implements Disposable {
    private final String myName;
    private final boolean mySupportsDeletion;
    private final List<String> myFilePaths = new ArrayList<String>();
    private final Map<String, String> myErrorsMap;
    private final SimpleTextAttributes myInvalidAttributes;
    private final Project myProject;
    private final String myFileGroupId;

    public GroupTreeNode(@NotNull String name, boolean supportsDeletion, @NotNull SimpleTextAttributes invalidAttributes, @NotNull Project project, @NotNull Map<String, String> errorsMap, String id) {
        this.myName = name;
        this.mySupportsDeletion = supportsDeletion;
        this.myInvalidAttributes = invalidAttributes;
        this.myProject = project;
        this.myErrorsMap = errorsMap;
        this.myFileGroupId = id;
    }

    public String getFileGroupId() {
        return this.myFileGroupId;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    public Icon getIcon(boolean expanded) {
        return AllIcons.Nodes.Folder;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getVirtualFiles() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            result2.addAll(((AbstractTreeNode)this.getChildAt(i)).getVirtualFiles());
        }
        return result2;
    }

    @Override
    @NotNull
    public Collection<File> getFiles() {
        ArrayList<File> result2 = new ArrayList<File>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            result2.addAll(((AbstractTreeNode)this.getChildAt(i)).getFiles());
        }
        return result2;
    }

    @Override
    protected int getItemsCount() {
        int result2 = 0;
        Enumeration<TreeNode> children = this.children();
        while (children.hasMoreElements()) {
            AbstractTreeNode treeNode = (AbstractTreeNode)children.nextElement();
            result2 += treeNode.getItemsCount();
        }
        return result2;
    }

    @Override
    protected boolean showStatistics() {
        return true;
    }

    @Override
    @NotNull
    public SimpleTextAttributes getAttributes() {
        return this.myFilterAttributes == null ? SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES : this.myFilterAttributes;
    }

    @Override
    public boolean getSupportsDeletion() {
        return this.mySupportsDeletion;
    }

    public void addFilePath(@NotNull String filePath) {
        this.myFilePaths.add(filePath);
    }

    public void rebuild(boolean groupByPackages, @Nullable Pair<PackageSetBase, NamedScopesHolder> filter, boolean showOnlyFilteredItems) {
        this.myFilterAttributes = null;
        if (this.containsGroups()) {
            this.rebuildGroups(groupByPackages, filter, showOnlyFilteredItems);
        } else {
            this.rebuildFiles(groupByPackages, filter, showOnlyFilteredItems);
        }
    }

    private void rebuildGroups(boolean groupByPackages, @Nullable Pair<PackageSetBase, NamedScopesHolder> filter, boolean showOnlyFilteredItems) {
        boolean apply2 = false;
        for (int i = 0; i < this.getChildCount(); ++i) {
            GroupTreeNode childGroup = (GroupTreeNode)this.getChildAt(i);
            childGroup.rebuild(groupByPackages, filter, showOnlyFilteredItems);
            apply2 |= childGroup.myFilterAttributes != null;
        }
        this.applyFilter(apply2);
    }

    private void rebuildFiles(boolean groupByPackages, @Nullable Pair<PackageSetBase, NamedScopesHolder> filter, boolean showOnlyFilteredItems) {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            TreeNode node = this.getChildAt(i);
            if (!(node instanceof Disposable)) continue;
            Disposer.dispose((Disposable)((Disposable)node));
        }
        this.removeAllChildren();
        if (groupByPackages) {
            this.buildPackages();
            this.acceptFilter(filter, showOnlyFilteredItems);
        } else {
            this.buildFiles(filter, showOnlyFilteredItems);
        }
        this.setTreeModel(this.myTreeModel);
        if (this.myTreeModel != null) {
            this.myTreeModel.nodeStructureChanged(this);
        }
    }

    private void buildPackages() {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        for (String myFilePath : this.myFilePaths) {
            files.add(new File(myFilePath));
        }
        GroupByPackages groupByPackages = new GroupByPackages(files);
        List<File> roots = groupByPackages.getRoots();
        this.addFiles(this, roots, files, groupByPackages, null);
    }

    private void addFiles(@NotNull AbstractTreeNode parentNode, @NotNull List<? extends File> roots, @NotNull Collection<? extends File> files, @NotNull GroupByPackages groupByPackages, String parentPath) {
        roots.sort((file1, file2) -> {
            boolean containsFile2;
            boolean containsFile1 = files.contains(file1);
            if (containsFile1 == (containsFile2 = files.contains(file2))) {
                return file1.getAbsolutePath().compareToIgnoreCase(file2.getAbsolutePath());
            }
            return containsFile1 ? 1 : -1;
        });
        for (File file : roots) {
            FileOrDirectoryTreeNode child = files.contains(file) ? new FileTreeNode(file.getAbsolutePath(), this.myInvalidAttributes, this.myProject, parentPath) : new DirectoryTreeNode(file.getAbsolutePath(), this.myProject, parentPath);
            Disposer.register((Disposable)((Disposable)parentNode), (Disposable)child);
            parentNode.add(child);
            this.addFiles(child, groupByPackages.getChildren(file), files, groupByPackages, child.getFilePath());
        }
    }

    private void buildFiles(@Nullable Pair<PackageSetBase, NamedScopesHolder> filter, boolean showOnlyFilteredItems) {
        this.myFilePaths.sort((path1, path2) -> path1.compareToIgnoreCase((String)path2));
        boolean apply2 = false;
        for (String filePath : this.myFilePaths) {
            String error;
            FileTreeNode child = new FileTreeNode(filePath, this.myInvalidAttributes, this.myProject, null);
            if (filter != null) {
                if (child.acceptFilter(filter, showOnlyFilteredItems)) {
                    apply2 = true;
                } else if (showOnlyFilteredItems) {
                    Disposer.dispose((Disposable)child);
                    continue;
                }
            }
            if ((error = this.myErrorsMap.get(filePath)) != null) {
                child.setErrorText(error);
            }
            this.add(child);
            Disposer.register((Disposable)this, (Disposable)child);
        }
        this.applyFilter(apply2);
    }

    private boolean containsGroups() {
        return this.myFilePaths.isEmpty();
    }

    public void dispose() {
    }
}

