/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.update.FileOrDirectoryTreeNode;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DirectoryTreeNode
extends FileOrDirectoryTreeNode {
    public DirectoryTreeNode(String path2, Project project, String parentPath) {
        super(path2, SimpleTextAttributes.ERROR_ATTRIBUTES, project, parentPath);
    }

    @Override
    protected int getItemsCount() {
        int result2 = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            result2 += ((FileOrDirectoryTreeNode)this.getChildAt(i)).getItemsCount();
        }
        return result2;
    }

    @Override
    protected boolean showStatistics() {
        return true;
    }

    @Override
    public Icon getIcon(boolean expanded) {
        return AllIcons.Nodes.Folder;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getVirtualFiles() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            FileOrDirectoryTreeNode child = (FileOrDirectoryTreeNode)this.getChildAt(i);
            result2.addAll(child.getVirtualFiles());
        }
        return result2;
    }

    @Override
    @NotNull
    public Collection<File> getFiles() {
        ArrayList<File> result2 = new ArrayList<File>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            FileOrDirectoryTreeNode child = (FileOrDirectoryTreeNode)this.getChildAt(i);
            result2.addAll(child.getFiles());
        }
        return result2;
    }
}

