/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.impl.VcsEP;
import com.intellij.openapi.vcs.roots.VcsRootProblemNotifier;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Alarm;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import java.util.List;
import java.util.MissingResourceException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRootScanner
implements AsyncVfsEventsListener {
    private static final Logger LOG = Logger.getInstance(VcsRootScanner.class);
    @NotNull
    private final VcsRootProblemNotifier myRootProblemNotifier;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectRootManager myProjectManager;
    @NotNull
    private final Alarm myAlarm;
    private static final long WAIT_BEFORE_SCAN = TimeUnit.SECONDS.toMillis(1L);

    public static void start(@NotNull Project project) {
        new VcsRootScanner(project).scheduleScan();
    }

    private VcsRootScanner(@NotNull Project project) {
        this.myProject = project;
        this.myProjectManager = ProjectRootManager.getInstance((Project)project);
        this.myRootProblemNotifier = VcsRootProblemNotifier.getInstance(project);
        AsyncVfsEventsPostProcessor.getInstance().addListener((AsyncVfsEventsListener)this, (Disposable)project);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
        VcsRootChecker.EXTENSION_POINT_NAME.addChangeListener(() -> this.scheduleScan(), (Disposable)project);
        VcsEP.EP_NAME.addChangeListener(() -> this.scheduleScan(), (Disposable)project);
    }

    public void filesChanged(@NotNull List<? extends VFileEvent> events) {
        List checkers = VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList();
        if (checkers.isEmpty()) {
            return;
        }
        for (VFileEvent vFileEvent : events) {
            VirtualFile file = vFileEvent.getFile();
            if (file == null || !file.isDirectory()) continue;
            VcsRootScanner.visitDirsRecursivelyWithoutExcluded(this.myProject, this.myProjectManager, file, dir -> {
                if (VcsRootScanner.isVcsDir(checkers, dir.getName())) {
                    this.scheduleScan();
                    return VirtualFileVisitor.skipTo((VirtualFile)file);
                }
                return VirtualFileVisitor.CONTINUE;
            });
        }
    }

    static void visitDirsRecursivelyWithoutExcluded(final @NotNull Project project, @NotNull ProjectRootManager projectRootManager, @NotNull VirtualFile root, final @NotNull Function<? super VirtualFile, ? extends VirtualFileVisitor.Result> dirFound) {
        final ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
        VirtualFileVisitor.Option depthLimit = VirtualFileVisitor.limit((int)Registry.intValue((String)"vcs.root.detector.folder.depth"));
        final Pattern ignorePattern = VcsRootScanner.parseDirIgnorePattern();
        if (VcsRootScanner.isUnderIgnoredDirectory(project, ignorePattern, root)) {
            return;
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS, depthLimit}){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (!file.isDirectory()) {
                    return CONTINUE;
                }
                if (VcsRootScanner.isIgnoredDirectory(project, ignorePattern, file)) {
                    return SKIP_CHILDREN;
                }
                if (((Boolean)ReadAction.compute(() -> project.isDisposed() || !fileIndex.isInContent(file))).booleanValue()) {
                    return SKIP_CHILDREN;
                }
                return (VirtualFileVisitor.Result)dirFound.apply(file);
            }
        });
    }

    private static boolean isVcsDir(@NotNull List<VcsRootChecker> checkers, @NotNull String filePath) {
        return checkers.stream().anyMatch(it -> it.isVcsDir(filePath));
    }

    private void scheduleScan() {
        if (this.myAlarm.isDisposed()) {
            return;
        }
        if (VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList().isEmpty()) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myAlarm, () -> this.myRootProblemNotifier.rescanAndNotifyIfNeeded()), WAIT_BEFORE_SCAN);
    }

    static boolean isUnderIgnoredDirectory(@NotNull Project project, @Nullable Pattern ignorePattern, @NotNull VirtualFile dir) {
        for (VirtualFile parent = dir; parent != null; parent = parent.getParent()) {
            if (!VcsRootScanner.isIgnoredDirectory(project, ignorePattern, parent)) continue;
            return true;
        }
        return false;
    }

    static boolean isIgnoredDirectory(@NotNull Project project, @Nullable Pattern ignorePattern, @NotNull VirtualFile dir) {
        if (ProjectLevelVcsManager.getInstance((Project)project).isIgnored(dir)) {
            LOG.debug("Skipping ignored dir: ", new Object[]{dir});
            return true;
        }
        if (ignorePattern != null && ignorePattern.matcher(dir.getName()).matches()) {
            LOG.debug("Skipping dir by pattern: ", new Object[]{dir});
            return true;
        }
        return false;
    }

    @Nullable
    static Pattern parseDirIgnorePattern() {
        try {
            return Pattern.compile(Registry.stringValue((String)"vcs.root.detector.ignore.pattern"));
        }
        catch (MissingResourceException | PatternSyntaxException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }
}

