/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowConfirmationOptionImpl;
import com.intellij.openapi.vcs.VcsShowOptionsSettingImpl;
import com.intellij.openapi.vcs.impl.projectlevelman.OptionsAndConfirmations;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProjectLevelVcsManagerSerialization {
    @NonNls
    private static final String OPTIONS_SETTING = "OptionsSetting";
    @NonNls
    private static final String CONFIRMATIONS_SETTING = "ConfirmationsSetting";
    @NonNls
    private static final String VALUE_ATTTIBUTE = "value";
    @NonNls
    private static final String ID_ATTRIBUTE = "id";

    public void readExternalUtil(Element element, OptionsAndConfirmations optionsAndConfirmations) throws InvalidDataException {
        String value;
        String id;
        for (Element subElement : element.getChildren(OPTIONS_SETTING)) {
            id = subElement.getAttributeValue(ID_ATTRIBUTE);
            value = subElement.getAttributeValue(VALUE_ATTTIBUTE);
            if (id == null || value == null) continue;
            VcsShowOptionsSettingImpl option2 = optionsAndConfirmations.getOrCreateOption(id);
            option2.setValue(Boolean.parseBoolean(value));
        }
        for (Element subElement : element.getChildren(CONFIRMATIONS_SETTING)) {
            VcsShowConfirmationOptionImpl confirmation;
            id = subElement.getAttributeValue(ID_ATTRIBUTE);
            value = subElement.getAttributeValue(VALUE_ATTTIBUTE);
            if (id == null || value == null || (confirmation = optionsAndConfirmations.getConfirmation(id)) == null) continue;
            confirmation.setValue(VcsShowConfirmationOption.Value.fromString((String)value));
        }
    }

    public void writeExternalUtil(@NotNull Element element, @NotNull OptionsAndConfirmations optionsAndConfirmations) throws WriteExternalException {
        Element settingElement;
        Map<String, VcsShowOptionsSettingImpl> options = optionsAndConfirmations.getOptions();
        Map<String, VcsShowConfirmationOptionImpl> confirmations = optionsAndConfirmations.getConfirmations();
        for (VcsShowOptionsSettingImpl vcsShowOptionsSettingImpl : options.values()) {
            if (vcsShowOptionsSettingImpl.getValue()) continue;
            settingElement = new Element(OPTIONS_SETTING);
            element.addContent(settingElement);
            settingElement.setAttribute(VALUE_ATTTIBUTE, Boolean.toString(vcsShowOptionsSettingImpl.getValue()));
            settingElement.setAttribute(ID_ATTRIBUTE, vcsShowOptionsSettingImpl.getDisplayName());
        }
        for (VcsShowConfirmationOptionImpl vcsShowConfirmationOptionImpl : confirmations.values()) {
            if (vcsShowConfirmationOptionImpl.getValue() == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION) continue;
            settingElement = new Element(CONFIRMATIONS_SETTING);
            element.addContent(settingElement);
            settingElement.setAttribute(VALUE_ATTTIBUTE, vcsShowConfirmationOptionImpl.getValue().toString());
            settingElement.setAttribute(ID_ATTRIBUTE, vcsShowConfirmationOptionImpl.getDisplayName());
        }
    }
}

