/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class MappingsToRoots {
    public static VirtualFile @NotNull [] getRootsUnderVcs(@NotNull Project project, @NotNull NewMappings newMappings, @NotNull AbstractVcs vcs) {
        ArrayList<VirtualFile> result2;
        ArrayList<VirtualFile> mappings = new ArrayList<VirtualFile>(newMappings.getMappingsAsFilesUnderVcs(vcs));
        AbstractVcs.RootsConvertor convertor = vcs.getCustomConvertor();
        List<Object> list = result2 = convertor != null ? convertor.convertRoots(mappings) : mappings;
        if (!vcs.allowsNestedRoots()) {
            result2.sort((Comparator<VirtualFile>)FilePathComparator.getInstance());
            ApplicationManager.getApplication().runReadAction(() -> {
                FileIndexFacade facade = (FileIndexFacade)ServiceManager.getService((Project)project, FileIndexFacade.class);
                int i = 1;
                while (i < result2.size()) {
                    VirtualFile current;
                    VirtualFile previous = (VirtualFile)result2.get(i - 1);
                    if (facade.isValidAncestor(previous, current = (VirtualFile)result2.get(i))) {
                        result2.remove(i);
                        continue;
                    }
                    ++i;
                }
            });
        }
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    @NotNull
    public static List<VirtualFile> getDetailedVcsMappings(@NotNull Project project, @NotNull NewMappings newMappings, @NotNull AbstractVcs vcs) {
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>(newMappings.getMappingsAsFilesUnderVcs(vcs));
        Collection<VirtualFile> modules = DefaultVcsRootPolicy.getInstance(project).getDefaultVcsRoots();
        List modulesUnderVcs = ContainerUtil.filter(modules, file -> {
            if (!file.isDirectory()) {
                return false;
            }
            NewMappings.MappedRoot root = newMappings.getMappedRootFor((VirtualFile)file);
            return root != null && vcs.equals((Object)root.vcs);
        });
        List modulesToAdd = (List)ApplicationManager.getApplication().runReadAction(() -> {
            FileIndexFacade facade = (FileIndexFacade)ServiceManager.getService((Project)project, FileIndexFacade.class);
            return ContainerUtil.filter((Collection)modulesUnderVcs, module -> ContainerUtil.or((Iterable)roots, root -> facade.isValidAncestor(root, module)));
        });
        return new ArrayList<VirtualFile>(ContainerUtil.union(roots, (Collection)modulesToAdd));
    }
}

