/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.containers.CollectionFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class FileWatchRequestModifier
implements Runnable,
Disposable {
    private final Project myProject;
    private final NewMappings myNewMappings;
    private final LocalFileSystem myLfs;
    private final Object LOCK = new Object();
    private Set<LocalFileSystem.WatchRequest> myWatches = Collections.emptySet();
    private boolean myDisposed;

    public FileWatchRequestModifier(@NotNull Project project, @NotNull NewMappings newMappings, @NotNull LocalFileSystem localFileSystem) {
        this.myLfs = localFileSystem;
        this.myProject = project;
        this.myNewMappings = newMappings;
        Disposer.register((Disposable)newMappings, (Disposable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myDisposed = true;
            this.myLfs.removeWatchedRoots(this.myWatches);
            this.myWatches = Collections.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myDisposed) {
                return;
            }
            if (!this.myProject.isInitialized()) {
                return;
            }
            Set newWatchedRoots = CollectionFactory.createFilePathSet();
            for (VcsDirectoryMapping mapping : this.myNewMappings.getDirectoryMappings()) {
                if (mapping.isDefaultMapping()) continue;
                newWatchedRoots.add(FileUtil.toCanonicalPath((String)mapping.getDirectory()));
            }
            this.myWatches = this.myLfs.replaceWatchedRoots(this.myWatches, (Collection)newWatchedRoots, null);
        }
    }
}

