/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePathMapping<T> {
    private final boolean myCaseSensitive;
    private final Map<String, T> myPathMap;
    private final TIntHashSet myPathHashSet = new TIntHashSet();

    public FilePathMapping(boolean caseSensitive) {
        this.myCaseSensitive = caseSensitive;
        this.myPathMap = new THashMap(FilePathHashingStrategy.create((boolean)caseSensitive));
    }

    public void add(@NotNull String filePath, @NotNull T value) {
        String path2 = StringUtil.trimTrailing((String)filePath, (char)'/');
        this.myPathMap.put(path2, value);
        this.myPathHashSet.add(FilePathMapping.pathHashCode(this.myCaseSensitive, path2));
    }

    public void remove(@NotNull String filePath) {
        String path2 = StringUtil.trimTrailing((String)filePath, (char)'/');
        this.myPathMap.remove(path2);
    }

    @NotNull
    public Collection<T> values() {
        return this.myPathMap.values();
    }

    @Nullable
    public T getMappingFor(@NotNull FilePath filePath) {
        String path2 = filePath.getPath();
        int index = 0;
        int prefixHash = 0;
        TIntArrayList matches = new TIntArrayList();
        if (this.myPathHashSet.contains(prefixHash)) {
            matches.add(index);
        }
        while (index < path2.length()) {
            int nextIndex = path2.indexOf(47, index + 1);
            if (nextIndex == -1) {
                nextIndex = path2.length();
            }
            if (this.myPathHashSet.contains(prefixHash = FilePathMapping.pathHashCode(this.myCaseSensitive, path2, index, nextIndex, prefixHash))) {
                matches.add(nextIndex);
            }
            index = nextIndex;
        }
        for (int i = matches.size() - 1; i >= 0; --i) {
            String prefix = path2.substring(0, matches.get(i));
            T root = this.myPathMap.get(prefix);
            if (root == null) continue;
            return root;
        }
        return null;
    }

    private static int pathHashCode(boolean caseSensitive, @NotNull String path2) {
        return FilePathMapping.pathHashCode(caseSensitive, path2, 0, path2.length(), 0);
    }

    private static int pathHashCode(boolean caseSensitive, @NotNull String path2, int offset1, int offset2, int prefixHash) {
        if (caseSensitive) {
            return StringUtil.stringHashCode((CharSequence)path2, (int)offset1, (int)offset2, (int)prefixHash);
        }
        return StringUtil.stringHashCodeInsensitive((CharSequence)path2, (int)offset1, (int)offset2, (int)prefixHash);
    }
}

