/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.impl.VcsEP;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcsesI;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AllVcses
implements AllVcsesI,
Disposable {
    private final Logger LOG = Logger.getInstance(AllVcses.class);
    private final Project myProject;
    private final Object myLock = new Object();
    private final Map<String, AbstractVcs> myVcses = new HashMap<String, AbstractVcs>();
    private final Map<String, VcsEP> myExtensions = new HashMap<String, VcsEP>();
    private final AtomicBoolean unbundledVcsNotificationShown = new AtomicBoolean();

    private AllVcses(@NotNull Project project) {
        this.myProject = project;
        Iterator iterator = VcsEP.EP_NAME.getExtensionList().iterator();
        while (iterator.hasNext()) {
            VcsEP extension;
            String name = extension.name;
            extension = (VcsEP)iterator.next();
            VcsEP oldEp = this.myExtensions.put(name, extension);
            if (oldEp == null) continue;
            this.LOG.error(String.format("registering duplicated EP. name: %s, old: %s, new: %s", name, oldEp.vcsClass, extension.vcsClass));
        }
        VcsEP.EP_NAME.addExtensionPointListener((ExtensionPointListener)new MyExtensionPointListener(), (Disposable)project);
    }

    public static AllVcsesI getInstance(@NotNull Project project) {
        return (AllVcsesI)project.getService(AllVcsesI.class);
    }

    public void registerManually(@NotNull AbstractVcs vcs) {
        ReadAction.run(() -> {
            Object object = this.myLock;
            synchronized (object) {
                String name = vcs.getName();
                if (this.myVcses.containsKey(name)) {
                    this.LOG.error(String.format("vcs is already registered: %s", vcs), new Throwable());
                    return;
                }
                if (this.myExtensions.containsKey(name)) {
                    this.LOG.error(String.format("can't override vcs from EP. vcs: %s, ep: %s", vcs, this.myExtensions.get((Object)name).vcsClass), new Throwable());
                    return;
                }
                this.myVcses.put(name, vcs);
                this.registerVcs(vcs);
            }
        });
        ProjectLevelVcsManagerImpl.getInstanceImpl(this.myProject).updateMappedVcsesImmediately();
    }

    public void unregisterManually(@NotNull AbstractVcs vcs) {
        ReadAction.run(() -> {
            Object object = this.myLock;
            synchronized (object) {
                String name = vcs.getName();
                if (!this.myVcses.containsKey(name)) {
                    this.LOG.error(String.format("vcs is not registered: %s", vcs), new Throwable());
                    return;
                }
                this.myVcses.remove(name);
                this.unregisterVcs(vcs);
            }
        });
        ProjectLevelVcsManagerImpl.getInstanceImpl(this.myProject).updateMappedVcsesImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractVcs getByName(@Nullable String name) {
        VcsEP ep;
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        Object object = this.myLock;
        synchronized (object) {
            AbstractVcs vcs = this.myVcses.get(name);
            if (vcs != null) {
                return vcs;
            }
            ep = this.myExtensions.get(name);
        }
        if (ep == null) {
            ObsoleteVcs obsoleteVcs = ObsoleteVcs.findByName(name);
            if (obsoleteVcs != null && this.unbundledVcsNotificationShown.compareAndSet(false, true)) {
                this.proposeToInstallPlugin(obsoleteVcs);
            }
            return null;
        }
        AbstractVcs vcs = ep.createVcs(this.myProject);
        this.LOG.assertTrue(name.equals(vcs.getName()), (Object)vcs);
        vcs.setupEnvironments();
        return (AbstractVcs)ReadAction.compute(() -> {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myExtensions.get(name) != ep) {
                    return null;
                }
                AbstractVcs oldVcs = this.myVcses.get(name);
                if (oldVcs != null) {
                    return oldVcs;
                }
                this.myVcses.put(name, vcs);
                this.registerVcs(vcs);
                return vcs;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VcsDescriptor getDescriptor(String name) {
        Object object = this.myLock;
        synchronized (object) {
            VcsEP ep = this.myExtensions.get(name);
            return ep == null ? null : ep.createDescriptor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            for (AbstractVcs vcs : this.myVcses.values()) {
                this.unregisterVcs(vcs);
            }
            this.myVcses.clear();
        }
    }

    private void registerVcs(@NotNull AbstractVcs vcs) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        try {
            vcs.loadSettings();
            vcs.doStart();
            vcs.getProvidedStatuses();
        }
        catch (VcsException e) {
            this.LOG.warn((Throwable)e);
        }
    }

    private void unregisterVcs(@NotNull AbstractVcs vcs) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        try {
            vcs.doShutdown();
        }
        catch (VcsException e) {
            this.LOG.warn((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myExtensions.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VcsDescriptor[] getAll() {
        ArrayList<VcsDescriptor> result2 = new ArrayList<VcsDescriptor>();
        Object object = this.myLock;
        synchronized (object) {
            for (VcsEP vcsEP : this.myExtensions.values()) {
                result2.add(vcsEP.createDescriptor());
            }
        }
        Collections.sort(result2);
        return result2.toArray(new VcsDescriptor[0]);
    }

    private void proposeToInstallPlugin(@NotNull ObsoleteVcs vcs) {
        String message = "The " + (Object)((Object)vcs) + " plugin was unbundled and needs to be installed manually";
        Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification("", message, NotificationType.WARNING, null);
        notification.addAction((AnAction)NotificationAction.createSimple((Supplier)VcsBundle.messagePointer((String)"action.NotificationAction.AllVcses.text.install", (Object[])new Object[0]), () -> {
            notification.expire();
            this.installPlugin(vcs);
        }));
        notification.addAction((AnAction)NotificationAction.createSimple((Supplier)VcsBundle.messagePointer((String)"action.NotificationAction.AllVcses.text.read.more", (Object[])new Object[0]), () -> BrowserUtil.browse((String)"https://blog.jetbrains.com/idea/2019/02/unbundling-tfs-and-cvs-integration-plugins/")));
        VcsNotifier.getInstance(this.myProject).notify(notification);
    }

    private void installPlugin(final @NotNull ObsoleteVcs vcs) {
        new Task.Backgroundable(this.myProject, "Installing Plugin"){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    PluginNode descriptor = MarketplaceRequests.getInstance().getLastCompatiblePluginUpdate(vcs.pluginId.getIdString(), null, indicator);
                    if (descriptor != null) {
                        PluginDownloader downloader = PluginDownloader.createDownloader((IdeaPluginDescriptor)descriptor);
                        if (downloader.prepareToInstall(indicator)) {
                            downloader.install();
                            DisabledPluginsState.enablePlugins(Collections.singletonList(descriptor), (boolean)true);
                            PluginManagerMain.notifyPluginsUpdated((Project)this.myProject);
                        }
                    } else {
                        this.showErrorNotification(vcs, "Couldn't find the plugin " + vcs.pluginId);
                    }
                }
                catch (IOException e) {
                    AllVcses.this.LOG.warn((Throwable)e);
                    this.showErrorNotification(vcs, e.getMessage());
                }
            }

            private void showErrorNotification(@NotNull ObsoleteVcs vcs2, @NotNull String message) {
                String title2 = "Failed to Install Plugin";
                Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(title2, message, NotificationType.ERROR, null);
                notification.addAction((AnAction)NotificationAction.createSimple((Supplier)VcsBundle.messagePointer((String)"action.NotificationAction.AllVcses.text.open.plugin.page", (Object[])new Object[0]), () -> BrowserUtil.browse((String)vcs2.pluginUrl)));
                VcsNotifier.getInstance(this.myProject).notify(notification);
            }
        }.queue();
    }

    private static enum ObsoleteVcs {
        CVS("CVS", "CVS", "https://plugins.jetbrains.com/plugin/10746-cvs-integration"),
        TFS("TFS", "TFS", "https://plugins.jetbrains.com/plugin/4578-tfs");

        @NotNull
        private final String vcsName;
        @NotNull
        private final PluginId pluginId;
        @NotNull
        private final String pluginUrl;

        private ObsoleteVcs(@NotNull String vcsName, String pluginId, String pluginUrl) {
            this.vcsName = vcsName;
            this.pluginId = PluginId.getId((String)pluginId);
            this.pluginUrl = pluginUrl;
        }

        @Nullable
        public static ObsoleteVcs findByName(@NotNull String name) {
            return (ObsoleteVcs)((Object)ContainerUtil.find((Object[])ObsoleteVcs.values(), vcs -> vcs.vcsName.equals(name)));
        }
    }

    private class MyExtensionPointListener
    implements ExtensionPointListener<VcsEP> {
        private MyExtensionPointListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void extensionAdded(@NotNull VcsEP extension, @NotNull PluginDescriptor pluginDescriptor) {
            Object object = AllVcses.this.myLock;
            synchronized (object) {
                AbstractVcs oldVcs;
                String name = extension.name;
                VcsEP oldEp = AllVcses.this.myExtensions.put(name, extension);
                if (oldEp != null) {
                    AllVcses.this.LOG.error(String.format("registering duplicated EP. name: %s, old: %s, new: %s", name, oldEp.vcsClass, extension.vcsClass));
                }
                if ((oldVcs = (AbstractVcs)AllVcses.this.myVcses.remove(name)) != null) {
                    AllVcses.this.LOG.error(String.format("overriding VCS with EP. name: %s, old: %s, new: %s", name, oldVcs.getClass(), extension.vcsClass));
                    AllVcses.this.unregisterVcs(oldVcs);
                }
            }
            ProjectLevelVcsManagerImpl.getInstanceImpl(AllVcses.this.myProject).updateMappedVcsesImmediately();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void extensionRemoved(@NotNull VcsEP extension, @NotNull PluginDescriptor pluginDescriptor) {
            Object object = AllVcses.this.myLock;
            synchronized (object) {
                boolean wasRemoved;
                String name = extension.name;
                AbstractVcs oldVcs = (AbstractVcs)AllVcses.this.myVcses.get(name);
                if (oldVcs != null) {
                    AllVcses.this.myVcses.remove(name);
                    AllVcses.this.unregisterVcs(oldVcs);
                }
                if (!(wasRemoved = AllVcses.this.myExtensions.remove(name, extension))) {
                    AllVcses.this.LOG.error(String.format("removing unregistered EP. name: %s, ep: %s", name, extension.vcsClass));
                }
            }
            ProjectLevelVcsManagerImpl.getInstanceImpl(AllVcses.this.myProject).updateMappedVcsesImmediately();
        }
    }
}

