/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.diff.DiffContentFactoryImpl;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.FileStatusManagerImpl;
import com.intellij.openapi.vcs.impl.FileStatusProvider;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class VcsFileStatusProvider
implements FileStatusProvider,
VcsBaseContentProvider {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(VcsFileStatusProvider.class);

    public static VcsFileStatusProvider getInstance(@NotNull Project project) {
        return (VcsFileStatusProvider)project.getService(VcsFileStatusProvider.class);
    }

    VcsFileStatusProvider(@NotNull Project project) {
        this.myProject = project;
        project.getMessageBus().connect().subscribe(ChangeListListener.TOPIC, (Object)new ChangeListAdapter(){

            public void changeListAdded(ChangeList list) {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }

            public void changeListRemoved(ChangeList list) {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }

            public void changeListUpdateDone() {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }
        });
        VcsBaseContentProvider.EP_NAME.addChangeListener((AreaInstance)this.myProject, this::fileStatusesChanged, (Disposable)this.myProject);
    }

    private void fileStatusesChanged() {
        FileStatusManager.getInstance((Project)this.myProject).fileStatusesChanged();
    }

    @NotNull
    public FileStatus getFileStatus(@NotNull VirtualFile virtualFile) {
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(virtualFile);
        if (vcs == null) {
            if (ScratchUtil.isScratch((VirtualFile)virtualFile)) {
                return FileStatus.SUPPRESSED;
            }
            return FileStatusManagerImpl.getDefaultStatus(virtualFile);
        }
        FileStatus status = ChangeListManager.getInstance((Project)this.myProject).getStatus(virtualFile);
        if (status == FileStatus.NOT_CHANGED && VcsFileStatusProvider.isDocumentModified(virtualFile)) {
            return FileStatus.MODIFIED;
        }
        if (status == FileStatus.NOT_CHANGED) {
            return FileStatusManagerImpl.getDefaultStatus(virtualFile);
        }
        return status;
    }

    private static boolean isDocumentModified(VirtualFile virtualFile) {
        if (virtualFile.isDirectory()) {
            return false;
        }
        return FileDocumentManager.getInstance().isFileModified(virtualFile);
    }

    public void refreshFileStatusFromDocument(@NotNull VirtualFile virtualFile, @NotNull Document doc) {
        ChangeProvider cp;
        boolean isStatusChanged;
        RollbackEnvironment rollbackEnvironment;
        AbstractVcs vcs;
        if (LOG.isDebugEnabled()) {
            LOG.debug("refreshFileStatusFromDocument: file.getModificationStamp()=" + virtualFile.getModificationStamp() + ", document.getModificationStamp()=" + doc.getModificationStamp());
        }
        if ((vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(virtualFile)) == null) {
            return;
        }
        FileStatusManagerImpl fileStatusManager = (FileStatusManagerImpl)FileStatusManager.getInstance((Project)this.myProject);
        FileStatus cachedStatus = fileStatusManager.getCachedStatus(virtualFile);
        boolean isDocumentModified = VcsFileStatusProvider.isDocumentModified(virtualFile);
        if (cachedStatus == FileStatus.MODIFIED && !isDocumentModified && !((ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)this.myProject)).getState().SHOW_DIALOG && (rollbackEnvironment = vcs.getRollbackEnvironment()) != null) {
            rollbackEnvironment.rollbackIfUnchanged(virtualFile);
        }
        boolean bl = isStatusChanged = cachedStatus != null && cachedStatus != FileStatus.NOT_CHANGED;
        if (isStatusChanged != isDocumentModified) {
            fileStatusManager.fileStatusChanged(virtualFile);
        }
        if ((cp = vcs.getChangeProvider()) != null && cp.isModifiedDocumentTrackingRequired()) {
            boolean isClmStatusChanged;
            FileStatus status = ChangeListManager.getInstance((Project)this.myProject).getStatus(virtualFile);
            boolean bl2 = isClmStatusChanged = status != FileStatus.NOT_CHANGED;
            if (isClmStatusChanged != isDocumentModified) {
                VcsDirtyScopeManager.getInstance((Project)this.myProject).fileDirty(virtualFile);
            }
        }
    }

    @NotNull
    public ThreeState getNotChangedDirectoryParentingStatus(@NotNull VirtualFile virtualFile) {
        if (VcsConfiguration.getInstance((Project)this.myProject).SHOW_DIRTY_RECURSIVELY) {
            return ChangeListManager.getInstance((Project)this.myProject).haveChangesUnder(virtualFile);
        }
        return ThreeState.NO;
    }

    @Override
    @Nullable
    public VcsBaseContentProvider.BaseContent getBaseRevision(@NotNull VirtualFile file) {
        if (!this.isHandledByVcs(file)) {
            VcsBaseContentProvider provider = this.findProviderFor(file);
            return provider == null ? null : provider.getBaseRevision(file);
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        Change change = changeListManager.getChange(file);
        if (change != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            return beforeRevision == null ? null : VcsFileStatusProvider.createBaseContent(this.myProject, beforeRevision);
        }
        FileStatus status = changeListManager.getStatus(file);
        if (status == FileStatus.HIJACKED) {
            DiffProvider diffProvider;
            AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(file);
            DiffProvider diffProvider2 = diffProvider = vcs != null ? vcs.getDiffProvider() : null;
            if (diffProvider != null) {
                VcsRevisionNumber currentRevision = diffProvider.getCurrentRevision(file);
                return currentRevision == null ? null : new HijackedBaseContent(this.myProject, diffProvider, file, currentRevision);
            }
        }
        return null;
    }

    @Nullable
    private VcsBaseContentProvider findProviderFor(@NotNull VirtualFile file) {
        return (VcsBaseContentProvider)VcsBaseContentProvider.EP_NAME.findFirstSafe((AreaInstance)this.myProject, it -> it.isSupported(file));
    }

    @Override
    public boolean isSupported(@NotNull VirtualFile file) {
        return this.isHandledByVcs(file) || this.findProviderFor(file) != null;
    }

    private boolean isHandledByVcs(@NotNull VirtualFile file) {
        return file.isInLocalFileSystem() && ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(file) != null;
    }

    @NotNull
    public static VcsBaseContentProvider.BaseContent createBaseContent(@NotNull Project project, @NotNull ContentRevision contentRevision) {
        return new BaseContentImpl(project, contentRevision);
    }

    @Nullable
    private static String loadContentRevision(@Nullable Project project, @NotNull ContentRevision contentRevision) {
        try {
            if (contentRevision instanceof ByteBackedContentRevision) {
                byte[] revisionContent = ((ByteBackedContentRevision)contentRevision).getContentAsBytes();
                FilePath filePath = contentRevision.getFile();
                if (revisionContent != null) {
                    Charset charset = DiffContentFactoryImpl.guessCharset((Project)project, (byte[])revisionContent, (FilePath)filePath);
                    return CharsetToolkit.decodeString((byte[])revisionContent, (Charset)charset);
                }
                return null;
            }
            return contentRevision.getContent();
        }
        catch (VcsException ex) {
            return null;
        }
    }

    private static class HijackedBaseContent
    implements VcsBaseContentProvider.BaseContent {
        @Nullable
        private final Project myProject;
        @NotNull
        private final DiffProvider myDiffProvider;
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final VcsRevisionNumber myRevision;

        HijackedBaseContent(@Nullable Project project, @NotNull DiffProvider diffProvider, @NotNull VirtualFile file, @NotNull VcsRevisionNumber revision) {
            this.myProject = project;
            this.myDiffProvider = diffProvider;
            this.myFile = file;
            this.myRevision = revision;
        }

        @Override
        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            return this.myRevision;
        }

        @Override
        @Nullable
        public String loadContent() {
            ContentRevision contentRevision = this.myDiffProvider.createFileContent(this.myRevision, this.myFile);
            if (contentRevision == null) {
                return null;
            }
            return VcsFileStatusProvider.loadContentRevision(this.myProject, contentRevision);
        }
    }

    private static class BaseContentImpl
    implements VcsBaseContentProvider.BaseContent {
        @Nullable
        private final Project myProject;
        @NotNull
        private final ContentRevision myContentRevision;

        BaseContentImpl(@NotNull Project project, @NotNull ContentRevision contentRevision) {
            this.myProject = project;
            this.myContentRevision = contentRevision;
        }

        @Override
        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            return this.myContentRevision.getRevisionNumber();
        }

        @Override
        @Nullable
        public String loadContent() {
            return VcsFileStatusProvider.loadContentRevision(this.myProject, this.myContentRevision);
        }
    }
}

