/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class DefaultVcsRootChecker
extends VcsRootChecker {
    @NotNull
    private final AbstractVcs myVcs;
    private final VcsDescriptor myVcsDescriptor;

    public DefaultVcsRootChecker(@NotNull AbstractVcs vcs) {
        this.myVcs = vcs;
        this.myVcsDescriptor = ProjectLevelVcsManager.getInstance((Project)vcs.getProject()).getDescriptor(vcs.getName());
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        return this.myVcs.getKeyInstanceMethod();
    }

    public boolean isRoot(@NotNull String path2) {
        if (this.myVcsDescriptor == null) {
            return false;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(new File(path2));
        if (file == null) {
            return false;
        }
        return this.myVcsDescriptor.probablyUnderVcs(file, false);
    }

    public boolean validateRoot(@NotNull String path2) {
        return true;
    }

    public boolean isVcsDir(@NotNull String dirName) {
        if (this.myVcsDescriptor == null) {
            return false;
        }
        return this.myVcsDescriptor.matchesVcsDirPattern(dirName);
    }

    public boolean areChildrenValidMappings() {
        if (this.myVcsDescriptor == null) {
            return false;
        }
        return this.myVcsDescriptor.areChildrenValidMappings();
    }
}

