/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.actions.AnnotateRevisionActionBase;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotateRevisionAction
extends AnnotateRevisionActionBase
implements DumbAware {
    public AnnotateRevisionAction() {
        super(VcsBundle.message((String)"annotate.action.name", (Object[])new Object[0]), VcsBundle.message((String)"annotate.action.description", (Object[])new Object[0]), AllIcons.Actions.Annotate);
        this.setShortcutSet(ActionManager.getInstance().getAction("Annotate").getShortcutSet());
    }

    @Override
    @Nullable
    protected Editor getEditor(@NotNull AnActionEvent e) {
        VirtualFile editorFile;
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        if (filePath == null) {
            return null;
        }
        VirtualFile virtualFile = filePath.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null && Comparing.equal((Object)(editorFile = FileDocumentManager.getInstance().getFile(editor.getDocument())), (Object)virtualFile)) {
            return editor;
        }
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(virtualFile);
        if (fileEditor instanceof TextEditor) {
            return ((TextEditor)fileEditor).getEditor();
        }
        return null;
    }

    @Override
    @Nullable
    protected AbstractVcs getVcs(@NotNull AnActionEvent e) {
        return VcsUtil.findVcs((AnActionEvent)e);
    }

    @Override
    @Nullable
    protected VirtualFile getFile(@NotNull AnActionEvent e) {
        Boolean nonLocal = (Boolean)e.getData(VcsDataKeys.VCS_NON_LOCAL_HISTORY_SESSION);
        if (Boolean.TRUE.equals(nonLocal)) {
            return null;
        }
        VirtualFile file = (VirtualFile)e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
        if (file == null || file.isDirectory()) {
            return null;
        }
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        if (filePath == null || filePath.getFileType().isBinary()) {
            return null;
        }
        return file;
    }

    @Override
    @Nullable
    protected VcsFileRevision getFileRevision(@NotNull AnActionEvent e) {
        VcsHistorySession historySession = (VcsHistorySession)e.getData(VcsDataKeys.HISTORY_SESSION);
        if (historySession == null) {
            return null;
        }
        VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        if (!historySession.isContentAvailable(revision)) {
            return null;
        }
        return revision;
    }
}

