/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.DiffVcsDataKeys;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.WaitForProgressToShow;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsHistoryUtil {
    @Deprecated
    public static final Key<Pair<FilePath, VcsRevisionNumber>> REVISION_INFO_KEY = DiffVcsDataKeys.REVISION_INFO;
    private static final Logger LOG = Logger.getInstance(VcsHistoryUtil.class);

    private VcsHistoryUtil() {
    }

    public static int compare(VcsFileRevision first, VcsFileRevision second) {
        if (first instanceof CurrentRevision && second instanceof CurrentRevision) {
            return VcsHistoryUtil.compareNumbers(first, second);
        }
        if (second instanceof CurrentRevision) {
            return -1 * VcsHistoryUtil.compare(second, first);
        }
        if (first instanceof CurrentRevision) {
            int result2 = VcsHistoryUtil.compareNumbers(first, second);
            if (result2 == 0) {
                return 1;
            }
            return result2;
        }
        return VcsHistoryUtil.compareNumbers(first, second);
    }

    public static int compareNumbers(VcsFileRevision first, VcsFileRevision second) {
        return first.getRevisionNumber().compareTo((Object)second.getRevisionNumber());
    }

    public static void showDiff(@NotNull Project project, @NotNull FilePath path2, @NotNull VcsFileRevision revision1, @NotNull VcsFileRevision revision2, @NotNull String title1, @NotNull String title2) throws VcsException, IOException {
        FilePath path1 = VcsHistoryUtil.getRevisionPath(revision1);
        FilePath path22 = VcsHistoryUtil.getRevisionPath(revision2);
        String title3 = path1 != null && path22 != null ? DiffRequestFactoryImpl.getTitle((FilePath)path1, (FilePath)path22, (String)" -> ") : DiffRequestFactoryImpl.getContentTitle((FilePath)path2);
        DiffContent diffContent1 = VcsHistoryUtil.loadContentForDiff(project, path2, revision1);
        DiffContent diffContent2 = VcsHistoryUtil.loadContentForDiff(project, path2, revision2);
        SimpleDiffRequest request = new SimpleDiffRequest(title3, diffContent1, diffContent2, title1, title2);
        diffContent1.putUserData(DiffVcsDataKeys.REVISION_INFO, VcsHistoryUtil.getRevisionInfo(revision1));
        diffContent2.putUserData(DiffVcsDataKeys.REVISION_INFO, VcsHistoryUtil.getRevisionInfo(revision2));
        WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> VcsHistoryUtil.lambda$showDiff$0(project, (DiffRequest)request), null, (Project)project);
    }

    @NotNull
    public static DiffContent loadContentForDiff(@NotNull Project project, @NotNull FilePath path2, @NotNull VcsFileRevision revision) throws IOException, VcsException {
        return VcsHistoryUtil.createContent(project, VcsHistoryUtil.loadRevisionContent(revision), revision, path2);
    }

    @Nullable
    private static Pair<FilePath, VcsRevisionNumber> getRevisionInfo(@NotNull VcsFileRevision revision) {
        if (revision instanceof VcsFileRevisionEx) {
            return Pair.create((Object)((VcsFileRevisionEx)revision).getPath(), (Object)revision.getRevisionNumber());
        }
        return null;
    }

    @Nullable
    private static FilePath getRevisionPath(@NotNull VcsFileRevision revision) {
        if (revision instanceof VcsFileRevisionEx) {
            return ((VcsFileRevisionEx)revision).getPath();
        }
        return null;
    }

    public static byte @NotNull [] loadRevisionContent(@NotNull VcsFileRevision revision) throws VcsException, IOException {
        byte[] content2 = revision.loadContent();
        if (content2 == null) {
            throw new VcsException("Failed to load content for revision " + revision.getRevisionNumber().asString());
        }
        return content2;
    }

    public static String loadRevisionContentGuessEncoding(@NotNull VcsFileRevision revision, @Nullable VirtualFile file, @Nullable Project project) throws VcsException, IOException {
        EncodingProjectManager e;
        byte[] bytes = VcsHistoryUtil.loadRevisionContent(revision);
        if (file != null) {
            return new String(bytes, file.getCharset());
        }
        EncodingProjectManager encodingProjectManager = e = project != null ? EncodingProjectManager.getInstance((Project)project) : null;
        if (e == null) {
            e = EncodingManager.getInstance();
        }
        return CharsetToolkit.bytesToString((byte[])bytes, (Charset)e.getDefaultCharset());
    }

    @NotNull
    private static DiffContent createContent(@NotNull Project project, byte @NotNull [] content2, @NotNull VcsFileRevision revision, @NotNull FilePath filePath) throws IOException {
        VirtualFile file;
        DiffContentFactoryEx contentFactory = DiffContentFactoryEx.getInstanceEx();
        if (VcsHistoryUtil.isCurrent(revision) && (file = filePath.getVirtualFile()) != null) {
            return contentFactory.create(project, file);
        }
        if (VcsHistoryUtil.isEmpty(revision)) {
            return contentFactory.createEmpty();
        }
        return contentFactory.createFromBytes(project, content2, filePath, revision.getDefaultCharset());
    }

    private static boolean isCurrent(VcsFileRevision revision) {
        return revision instanceof CurrentRevision;
    }

    public static boolean isEmpty(VcsFileRevision revision) {
        return revision == null || VcsFileRevision.NULL.equals(revision);
    }

    public static void showDifferencesInBackground(final @NotNull Project project, final @NotNull FilePath filePath, final @NotNull VcsFileRevision older, final @NotNull VcsFileRevision newer) {
        new Task.Backgroundable(project, VcsBundle.message((String)"file.history.diff.revisions.process", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    VcsHistoryUtil.showDiff(project, filePath, older, newer, this.makeTitle(older), this.makeTitle(newer));
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                    WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((String)VcsBundle.message((String)"message.text.cannot.show.differences", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.show.differences", (Object[])new Object[0])), null, (Project)project);
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }

            @NotNull
            private String makeTitle(@NotNull VcsFileRevision revision) {
                return revision.getRevisionNumber().asString() + (revision instanceof CurrentRevision ? " (" + VcsBundle.message((String)"diff.title.local", (Object[])new Object[0]) + ")" : "");
            }
        }.queue();
    }

    private static /* synthetic */ void lambda$showDiff$0(Project project, DiffRequest request) {
        DiffManager.getInstance().showDiff(project, request);
    }
}

