/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.VcsAnnotation;
import com.intellij.openapi.vcs.annotate.VcsCacheableAnnotationProvider;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.CacheableAnnotationProvider;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsAnnotationCachedProxy
implements AnnotationProvider,
CacheableAnnotationProvider {
    private final VcsHistoryCache myCache;
    private final AbstractVcs myVcs;
    private static final Logger LOG = Logger.getInstance(VcsAnnotationCachedProxy.class);
    private final AnnotationProvider myAnnotationProvider;

    public VcsAnnotationCachedProxy(@NotNull AbstractVcs vcs, @NotNull AnnotationProvider provider) {
        assert (provider instanceof VcsCacheableAnnotationProvider);
        this.myVcs = vcs;
        this.myCache = ProjectLevelVcsManager.getInstance((Project)vcs.getProject()).getVcsHistoryCache();
        this.myAnnotationProvider = provider;
    }

    public FileAnnotation annotate(VirtualFile file) throws VcsException {
        DiffProvider diffProvider = this.myVcs.getDiffProvider();
        VcsRevisionNumber currentRevision = diffProvider.getCurrentRevision(file);
        return this.annotate(file, currentRevision, true, (ThrowableComputable<? extends FileAnnotation, VcsException>)((ThrowableComputable)() -> this.myAnnotationProvider.annotate(file)));
    }

    public FileAnnotation annotate(VirtualFile file, VcsFileRevision revision) throws VcsException {
        return this.annotate(file, revision.getRevisionNumber(), false, (ThrowableComputable<? extends FileAnnotation, VcsException>)((ThrowableComputable)() -> this.myAnnotationProvider.annotate(file, revision)));
    }

    @Override
    public void populateCache(@NotNull VirtualFile file) throws VcsException {
        this.annotate(file);
    }

    private FileAnnotation annotate(VirtualFile file, VcsRevisionNumber revisionNumber, boolean currentRevision, ThrowableComputable<? extends FileAnnotation, VcsException> delegate) throws VcsException {
        FileAnnotation fileAnnotation;
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        VcsCacheableAnnotationProvider cacheableAnnotationProvider = (VcsCacheableAnnotationProvider)this.myAnnotationProvider;
        VcsAnnotation vcsAnnotation = null;
        if (revisionNumber != null) {
            Object cachedData = this.myCache.getAnnotation(filePath, this.myVcs.getKeyInstanceMethod(), revisionNumber);
            vcsAnnotation = (VcsAnnotation)ObjectUtils.tryCast((Object)cachedData, VcsAnnotation.class);
        }
        if (vcsAnnotation != null) {
            VcsHistoryProvider historyProvider = this.myVcs.getVcsHistoryProvider();
            VcsAbstractHistorySession history = this.getHistory(revisionNumber, filePath, historyProvider, vcsAnnotation.getFirstRevision());
            if (history == null) {
                return null;
            }
            ContentRevision fileContent = this.myVcs.getDiffProvider().createFileContent(revisionNumber, file);
            FileAnnotation restored = cacheableAnnotationProvider.restore(vcsAnnotation, history, fileContent.getContent(), currentRevision, revisionNumber);
            if (restored != null) {
                return restored;
            }
        }
        if ((vcsAnnotation = cacheableAnnotationProvider.createCacheable(fileAnnotation = (FileAnnotation)delegate.compute())) == null) {
            return fileAnnotation;
        }
        if (revisionNumber != null) {
            this.myCache.putAnnotation(filePath, this.myVcs.getKeyInstanceMethod(), revisionNumber, (Object)vcsAnnotation);
        }
        if (this.myVcs.getVcsHistoryProvider() instanceof VcsCacheableHistorySessionFactory) {
            this.loadHistoryInBackgroundToCache(revisionNumber, filePath, vcsAnnotation);
        }
        return fileAnnotation;
    }

    private void loadHistoryInBackgroundToCache(VcsRevisionNumber revisionNumber, FilePath filePath, VcsAnnotation vcsAnnotation) {
        BackgroundTaskUtil.executeOnPooledThread((Disposable)this.myVcs.getProject(), () -> {
            try {
                this.getHistory(revisionNumber, filePath, this.myVcs.getVcsHistoryProvider(), vcsAnnotation.getFirstRevision());
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        });
    }

    private VcsAbstractHistorySession getHistory(VcsRevisionNumber revision, FilePath filePath, VcsHistoryProvider historyProvider, @Nullable VcsRevisionNumber firstRevision) throws VcsException {
        VcsAbstractHistorySession sessionFor;
        boolean historyCacheSupported = historyProvider instanceof VcsCacheableHistorySessionFactory;
        if (historyCacheSupported) {
            VcsFileRevision recentRevision;
            VcsCacheableHistorySessionFactory cacheableHistorySessionFactory = (VcsCacheableHistorySessionFactory)historyProvider;
            VcsAbstractHistorySession cachedSession = this.myCache.getMaybePartial(filePath, this.myVcs.getKeyInstanceMethod(), cacheableHistorySessionFactory);
            if (cachedSession != null && !cachedSession.getRevisionList().isEmpty() && (recentRevision = (VcsFileRevision)cachedSession.getRevisionList().get(0)).getRevisionNumber().compareTo((Object)revision) >= 0 && (firstRevision == null || cachedSession.getHistoryAsMap().containsKey(firstRevision))) {
                return cachedSession;
            }
        }
        if ((sessionFor = firstRevision != null ? this.limitedHistory(filePath, firstRevision) : (VcsAbstractHistorySession)historyProvider.createSessionFor(filePath)) != null && historyCacheSupported) {
            VcsCacheableHistorySessionFactory cacheableHistorySessionFactory = (VcsCacheableHistorySessionFactory)historyProvider;
            FilePath correctedPath = cacheableHistorySessionFactory.getUsedFilePath(sessionFor);
            this.myCache.put(filePath, correctedPath, this.myVcs.getKeyInstanceMethod(), sessionFor, cacheableHistorySessionFactory, firstRevision == null);
        }
        return sessionFor;
    }

    public boolean isAnnotationValid(@NotNull VcsFileRevision rev) {
        return this.myAnnotationProvider.isAnnotationValid(rev);
    }

    private VcsAbstractHistorySession limitedHistory(FilePath filePath, final @NotNull VcsRevisionNumber firstNumber) throws VcsException {
        final VcsAbstractHistorySession[] result2 = new VcsAbstractHistorySession[1];
        final VcsException[] exc = new VcsException[1];
        try {
            this.myVcs.getVcsHistoryProvider().reportAppendableHistory(filePath, new VcsAppendableHistorySessionPartner(){

                public void reportCreatedEmptySession(VcsAbstractHistorySession session) {
                    result2[0] = session;
                }

                public void acceptRevision(VcsFileRevision revision) {
                    result2[0].appendRevision(revision);
                    if (firstNumber.equals(revision.getRevisionNumber())) {
                        throw new ProcessCanceledException();
                    }
                }

                public void reportException(VcsException exception) {
                    exc[0] = exception;
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        if (exc[0] != null) {
            throw exc[0];
        }
        return result2[0];
    }
}

