/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDiffFromHistoryHandler<T extends VcsFileRevision>
implements DiffFromHistoryHandler {
    private static final Logger LOG = Logger.getInstance(BaseDiffFromHistoryHandler.class);
    @NotNull
    protected final Project myProject;

    protected BaseDiffFromHistoryHandler(@NotNull Project project) {
        this.myProject = project;
    }

    public void showDiffForOne(@NotNull AnActionEvent e, @NotNull Project project, @NotNull FilePath filePath, @NotNull VcsFileRevision previousRevision, @NotNull VcsFileRevision revision) {
        this.doShowDiff(filePath, previousRevision, revision);
    }

    public void showDiffForTwo(@NotNull Project project, @NotNull FilePath filePath, @NotNull VcsFileRevision older, @NotNull VcsFileRevision newer) {
        this.doShowDiff(filePath, older, newer);
    }

    protected void doShowDiff(@NotNull FilePath filePath, @NotNull VcsFileRevision older, @NotNull VcsFileRevision newer) {
        if (!filePath.isDirectory()) {
            VcsHistoryUtil.showDifferencesInBackground(this.myProject, filePath, older, newer);
        } else if (older.equals(VcsFileRevision.NULL)) {
            VcsFileRevision right = newer;
            this.showAffectedChanges(filePath, right);
        } else if (newer instanceof CurrentRevision) {
            VcsFileRevision left = older;
            this.showChangesBetweenRevisions(filePath, left, null);
        } else {
            VcsFileRevision left = older;
            VcsFileRevision right = newer;
            this.showChangesBetweenRevisions(filePath, left, right);
        }
    }

    protected void showChangesBetweenRevisions(final @NotNull FilePath path2, @NotNull T older, @Nullable T newer) {
        new CollectChangesTask(VcsBundle.message((String)"file.history.diff.handler.comparing.process", (Object[])new Object[0]), (VcsFileRevision)older, (VcsFileRevision)newer){
            final /* synthetic */ VcsFileRevision val$older;
            final /* synthetic */ VcsFileRevision val$newer;
            {
                this.val$older = vcsFileRevision;
                this.val$newer = vcsFileRevision2;
                super(title2);
            }

            @Override
            @NotNull
            public List<Change> getChanges() throws VcsException {
                return BaseDiffFromHistoryHandler.this.getChangesBetweenRevisions(path2, this.val$older, this.val$newer);
            }

            @Override
            @NotNull
            public String getDialogTitle() {
                return BaseDiffFromHistoryHandler.this.getChangesBetweenRevisionsDialogTitle(path2, this.val$older, this.val$newer);
            }
        }.queue();
    }

    protected void showAffectedChanges(final @NotNull FilePath path2, @NotNull T rev) {
        new CollectChangesTask(VcsBundle.message((String)"file.history.diff.handler.collecting.affected.process", (Object[])new Object[0]), (VcsFileRevision)rev){
            final /* synthetic */ VcsFileRevision val$rev;
            {
                this.val$rev = vcsFileRevision;
                super(title2);
            }

            @Override
            @NotNull
            public List<Change> getChanges() throws VcsException {
                return BaseDiffFromHistoryHandler.this.getAffectedChanges(path2, this.val$rev);
            }

            @Override
            @NotNull
            public String getDialogTitle() {
                return BaseDiffFromHistoryHandler.this.getAffectedChangesDialogTitle(path2, this.val$rev);
            }
        }.queue();
    }

    @NotNull
    protected abstract List<Change> getChangesBetweenRevisions(@NotNull FilePath var1, @NotNull T var2, @Nullable T var3) throws VcsException;

    @NotNull
    protected abstract List<Change> getAffectedChanges(@NotNull FilePath var1, @NotNull T var2) throws VcsException;

    @NotNull
    protected abstract String getPresentableName(@NotNull T var1);

    protected void showChangesDialog(@NotNull @Nls String title2, @NotNull List<? extends Change> changes) {
        VcsDiffUtil.showChangesDialog(this.myProject, title2, changes);
    }

    protected void showError(@NotNull VcsException e, @NotNull @Nls String logMessage) {
        LOG.info(logMessage, (Throwable)e);
        VcsBalloonProblemNotifier.showOverVersionControlView(this.myProject, e.getMessage(), MessageType.ERROR);
    }

    @Nls
    @NotNull
    protected String getChangesBetweenRevisionsDialogTitle(@NotNull FilePath path2, @NotNull T rev1, @Nullable T rev2) {
        String rev1Title = this.getPresentableName(rev1);
        if (rev2 == null) {
            return VcsBundle.message((String)"file.history.diff.handler.paths.diff.with.local.title", (Object[])new Object[]{rev1Title, path2.getName()});
        }
        String rev2Title = this.getPresentableName(rev2);
        return VcsBundle.message((String)"file.history.diff.handler.paths.diff.title", (Object[])new Object[]{rev1Title, rev2Title, path2.getName()});
    }

    @Nls
    @NotNull
    protected String getAffectedChangesDialogTitle(@NotNull FilePath path2, @NotNull T rev) {
        return VcsBundle.message((String)"file.history.diff.handler.affected.changes.title", (Object[])new Object[]{this.getPresentableName(rev), path2.getName()});
    }

    protected abstract class CollectChangesTask
    extends Task.Backgroundable {
        private List<Change> myChanges;

        public CollectChangesTask(String title2) {
            super(BaseDiffFromHistoryHandler.this.myProject, title2);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            try {
                this.myChanges = this.getChanges();
            }
            catch (VcsException e) {
                BaseDiffFromHistoryHandler.this.showError(e, VcsBundle.message((String)"file.history.diff.handler.process.error", (Object[])new Object[]{this.getDialogTitle()}));
            }
        }

        @NotNull
        public abstract List<Change> getChanges() throws VcsException;

        @Nls
        @NotNull
        public abstract String getDialogTitle();

        public void onSuccess() {
            BaseDiffFromHistoryHandler.this.showChangesDialog(this.getDialogTitle(), ContainerUtil.notNullize(this.myChanges));
        }
    }
}

