/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vcs.ex.LineStatusActionBase;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.LineStatusTrackerI;
import com.intellij.openapi.vcs.ex.Range;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RollbackLineStatusAction
extends LineStatusActionBase {
    @Override
    protected void doAction(@NotNull LineStatusTrackerI<?> tracker, @NotNull Editor editor) {
        RollbackLineStatusAction.rollback(tracker, editor);
    }

    public static void rollback(@NotNull LineStatusTrackerI<?> tracker, @NotNull Editor editor) {
        BitSet selectedLines = DiffUtil.getSelectedLines((Editor)editor);
        tracker.rollbackChanges(selectedLines);
    }

    public static void rollback(@NotNull LineStatusTrackerBase<?> tracker, @NotNull Range range, @Nullable Editor editor) {
        if (editor != null) {
            DiffUtil.moveCaretToLineRangeIfNeeded((Editor)editor, (int)range.getLine1(), (int)range.getLine2());
        }
        tracker.rollbackChanges(range);
    }

    @Deprecated
    public static void rollback(@NotNull LineStatusTrackerBase<?> tracker, @NotNull Editor editor) {
        RollbackLineStatusAction.rollback(tracker, editor);
    }
}

