/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.ide.ui.OptionsSearchTopHitProvider;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.ProjectTopHitCache;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsOptionsTopHitProviderBase
implements OptionsSearchTopHitProvider.ProjectLevelProvider {
    protected boolean isEnabled(@NotNull Project project, @Nullable VcsKey vcsKey) {
        if (project.isDefault()) {
            return true;
        }
        if (vcsKey == null) {
            return false;
        }
        List<AbstractVcs> activeVcses = Arrays.asList(ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss());
        return ContainerUtil.exists(activeVcses, it -> vcsKey.equals((Object)it.getKeyInstanceMethod()));
    }

    public static class InitMappingsListenerActivity
    implements ProjectManagerListener {
        public void projectOpened(@NotNull Project project) {
            project.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> InitMappingsListenerActivity.invalidateTopHitCaches(project));
        }

        private static void invalidateTopHitCaches(@NotNull Project project) {
            for (OptionsSearchTopHitProvider.ProjectLevelProvider provider : OptionsTopHitProvider.PROJECT_LEVEL_EP.getExtensionList()) {
                if (!(provider instanceof VcsOptionsTopHitProviderBase)) continue;
                ProjectTopHitCache.getInstance((Project)project).invalidateCachedOptions(provider.getClass());
            }
        }
    }
}

