/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentEP;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentI;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerKt;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerListener;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.vcs.changes.ui.VcsToolWindowFactory;
import com.intellij.openapi.vcs.changes.ui.VcsToolWindowFactoryKt;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.NotNullFunction;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000E\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007*\u0001\u000f\b&\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0002\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/VcsToolWindowFactory;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "createExtensionContent", "Lcom/intellij/ui/content/Content;", "project", "Lcom/intellij/openapi/project/Project;", "extension", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentEP;", "createToolWindowContent", "", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "getContentManagerListener", "com/intellij/openapi/vcs/changes/ui/VcsToolWindowFactory$getContentManagerListener$1", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindow;)Lcom/intellij/openapi/vcs/changes/ui/VcsToolWindowFactory$getContentManagerListener$1;", "getExtensions", "", "init", "window", "shouldBeAvailable", "", "updateAvailability", "updateContent", "updateContentIfCreated", "updateState", "Companion", "ExtensionListener", "intellij.platform.vcs.impl"})
public abstract class VcsToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    public static final Companion Companion = new Companion(null);

    public void init(@NotNull ToolWindow window) {
        ToolWindow toolWindow = window;
        if (toolWindow == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.wm.ex.ToolWindowEx");
        }
        Project project = ((ToolWindowEx)toolWindow).getProject();
        this.updateState(project, window);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)new VcsListener(this, project, window){
            final /* synthetic */ VcsToolWindowFactory this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ToolWindow $window;

            public final void directoryMappingChanged() {
                ModalityState modalityState$iv = null;
                boolean $i$f$runInEdt = false;
                Application app$iv = ApplicationManager.getApplication();
                if (app$iv.isDispatchThread()) {
                    boolean bl = false;
                    if (!this.$project.isDisposed()) {
                        this.this$0.updateState(this.$project, this.$window);
                    }
                } else {
                    boolean $i$f$invokeLater = false;
                    ApplicationManager.getApplication().invokeLater(new Runnable(this){
                        final /* synthetic */ init.1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void run() {
                            boolean bl = false;
                            if (!this.this$0.$project.isDisposed()) {
                                this.this$0.this$0.updateState(this.this$0.$project, this.this$0.$window);
                            }
                        }
                    }, ModalityState.defaultModalityState());
                }
            }
            {
                this.this$0 = vcsToolWindowFactory;
                this.$project = project;
                this.$window = toolWindow;
            }
        });
        connection.subscribe(ChangesViewContentManagerListener.TOPIC, (Object)new ChangesViewContentManagerListener(this, project, window){
            final /* synthetic */ VcsToolWindowFactory this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ToolWindow $window;

            public void toolWindowMappingChanged() {
                block0: {
                    this.this$0.updateState(this.$project, this.$window);
                    ContentManager contentManager = ((ToolWindowEx)this.$window).getContentManagerIfCreated();
                    if (contentManager == null) break block0;
                    ChangesViewContentManagerKt.selectFirstContent(contentManager);
                }
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
                this.$window = $captured_local_variable$2;
            }
        });
        ChangesViewContentEP.EP_NAME.addExtensionPointListener((AreaInstance)project, (ExtensionPointListener)new ExtensionListener((ToolWindowEx)window), ((ToolWindowEx)window).getDisposable());
        window.addContentManagerListener((ContentManagerListener)this.getContentManagerListener(project, window));
    }

    public boolean shouldBeAvailable(@NotNull Project project) {
        return Companion.getVcsManager$intellij_platform_vcs_impl(project).hasAnyMappings() || Companion.getVcsManager$intellij_platform_vcs_impl(project).isConsoleVisible();
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        this.updateContent(project, toolWindow);
        VcsToolWindowFactoryKt.access$getChangesViewContentManager$p(project).attachToolWindow(toolWindow);
        UIUtil.putClientProperty((JComponent)toolWindow.getComponent(), (Key)VcsToolWindowFactoryKt.access$getIS_CONTENT_CREATED$p(), (Object)true);
    }

    protected void updateState(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        this.updateAvailability(project, toolWindow);
        this.updateContentIfCreated(project, toolWindow);
    }

    private final void updateAvailability(Project project, ToolWindow toolWindow) {
        boolean available = this.shouldBeAvailable(project);
        if (available && !toolWindow.isAvailable()) {
            toolWindow.setShowStripeButton(true);
        }
        toolWindow.setAvailable(available);
    }

    private final void updateContentIfCreated(Project project, ToolWindow toolWindow) {
        if (Intrinsics.areEqual((Object)((Boolean)UIUtil.getClientProperty((Object)toolWindow.getComponent(), (Key)VcsToolWindowFactoryKt.access$getIS_CONTENT_CREATED$p())), (Object)true) ^ true) {
            return;
        }
        this.updateContent(project, toolWindow);
    }

    private final void updateContent(Project project, ToolWindow toolWindow) {
        ChangesViewContentI changesViewContentManager = VcsToolWindowFactoryKt.access$getChangesViewContentManager$p(project);
        Iterable $this$forEach$iv = this.getExtensions(project, toolWindow);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChangesViewContentEP extension = (ChangesViewContentEP)element$iv;
            boolean bl = false;
            NotNullFunction<Project, Boolean> notNullFunction = extension.newPredicateInstance(project);
            boolean isVisible = notNullFunction == null || ((Boolean)notNullFunction.fun((Object)project)).booleanValue();
            Content content2 = (Content)CollectionsKt.firstOrNull(changesViewContentManager.findContents(new Predicate<Content>(extension){
                final /* synthetic */ ChangesViewContentEP $extension;

                public final boolean test(Content it) {
                    return VcsToolWindowFactoryKt.access$getExtension(it) == this.$extension;
                }
                {
                    this.$extension = changesViewContentEP;
                }
            }));
            if (isVisible && content2 == null) {
                changesViewContentManager.addContent(this.createExtensionContent(project, extension));
                continue;
            }
            if (isVisible || content2 == null) continue;
            changesViewContentManager.removeContent(content2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<ChangesViewContentEP> getExtensions(Project project, ToolWindow toolWindow) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = ChangesViewContentEP.EP_NAME.getExtensions((AreaInstance)project);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChangesViewContentEP it = (ChangesViewContentEP)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)ChangesViewContentManager.Companion.getToolWindowIdFor(project, it.tabName), (Object)toolWindow.getId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Content createExtensionContent(Project project, ChangesViewContentEP extension) {
        Content content2;
        block1: {
            Supplier<String> supplier = extension.newDisplayNameSupplierInstance(project);
            if (supplier == null || (supplier = supplier.get()) == null) {
                supplier = extension.tabName;
            }
            Supplier<String> displayName = supplier;
            content2 = ContentFactory.SERVICE.getInstance().createContent((JComponent)new JPanel(null), (String)((Object)displayName), false);
            boolean bl = false;
            boolean bl2 = false;
            Content $this$apply = content2;
            boolean bl3 = false;
            $this$apply.setCloseable(false);
            $this$apply.setTabName(extension.tabName);
            $this$apply.putUserData(VcsToolWindowFactoryKt.access$getCHANGES_VIEW_EXTENSION$p(), (Object)extension);
            $this$apply.putUserData(ChangesViewContentManager.CONTENT_PROVIDER_SUPPLIER_KEY, (Object)new Function0<ChangesViewContentProvider>(extension, project){
                final /* synthetic */ ChangesViewContentEP $extension$inlined;
                final /* synthetic */ Project $project$inlined;
                {
                    this.$extension$inlined = changesViewContentEP;
                    this.$project$inlined = project;
                    super(0);
                }

                public final ChangesViewContentProvider invoke() {
                    return this.$extension$inlined.getInstance(this.$project$inlined);
                }
            });
            ChangesViewContentProvider.Preloader preloader = extension.newPreloaderInstance(project);
            if (preloader == null) break block1;
            preloader.preloadTabContent($this$apply);
        }
        return content2;
    }

    private final getContentManagerListener.1 getContentManagerListener(Project project, ToolWindow toolWindow) {
        return new ContentManagerListener(this, project, toolWindow){
            final /* synthetic */ VcsToolWindowFactory this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ToolWindow $toolWindow;

            public void contentAdded(@NotNull ContentManagerEvent event) {
                this.scheduleUpdate();
            }

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                this.scheduleUpdate();
            }

            private final void scheduleUpdate() {
                ModalityState modalityState$iv = null;
                boolean $i$f$invokeLater = false;
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ getContentManagerListener.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run() {
                        boolean bl = false;
                        if (!this.this$0.$project.isDisposed()) {
                            this.this$0.this$0.updateState(this.this$0.$project, this.this$0.$toolWindow);
                        }
                    }
                }, ModalityState.defaultModalityState());
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
                this.$toolWindow = $captured_local_variable$2;
            }
        };
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/VcsToolWindowFactory$ExtensionListener;", "Lcom/intellij/openapi/extensions/ExtensionPointListener;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentEP;", "toolWindow", "Lcom/intellij/openapi/wm/ex/ToolWindowEx;", "(Lcom/intellij/openapi/vcs/changes/ui/VcsToolWindowFactory;Lcom/intellij/openapi/wm/ex/ToolWindowEx;)V", "extensionAdded", "", "extension", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "extensionRemoved", "intellij.platform.vcs.impl"})
    private final class ExtensionListener
    implements ExtensionPointListener<ChangesViewContentEP> {
        private final ToolWindowEx toolWindow;

        public void extensionAdded(@NotNull ChangesViewContentEP extension, @NotNull PluginDescriptor pluginDescriptor) {
            VcsToolWindowFactory.this.updateContentIfCreated(this.toolWindow.getProject(), (ToolWindow)this.toolWindow);
        }

        public void extensionRemoved(@NotNull ChangesViewContentEP extension, @NotNull PluginDescriptor pluginDescriptor) {
            Content content2;
            block3: {
                ContentManager contentManager = this.toolWindow.getContentManagerIfCreated();
                if (contentManager == null) {
                    return;
                }
                ContentManager contentManager2 = contentManager;
                Content[] $this$firstOrNull$iv = contentManager2.getContents();
                boolean $i$f$firstOrNull = false;
                Content[] contentArray = $this$firstOrNull$iv;
                int n = contentArray.length;
                for (int i = 0; i < n; ++i) {
                    Content element$iv;
                    Content it = element$iv = contentArray[i];
                    boolean bl = false;
                    if (!(VcsToolWindowFactoryKt.access$getExtension(it) == extension)) continue;
                    content2 = element$iv;
                    break block3;
                }
                content2 = null;
            }
            if (content2 == null) {
                return;
            }
            Content content3 = content2;
            VcsToolWindowFactoryKt.access$getChangesViewContentManager$p(this.toolWindow.getProject()).removeContent(content3);
        }

        public ExtensionListener(ToolWindowEx toolWindow) {
            this.toolWindow = toolWindow;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/VcsToolWindowFactory$Companion;", "", "()V", "vcsManager", "Lcom/intellij/openapi/vcs/ProjectLevelVcsManager;", "Lcom/intellij/openapi/project/Project;", "getVcsManager$intellij_platform_vcs_impl", "(Lcom/intellij/openapi/project/Project;)Lcom/intellij/openapi/vcs/ProjectLevelVcsManager;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        @NotNull
        public final ProjectLevelVcsManager getVcsManager$intellij_platform_vcs_impl(@NotNull Project $this$vcsManager) {
            return ProjectLevelVcsManager.getInstance((Project)$this$vcsManager);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

