/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.ui.BaseChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangeListRemoteState;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserIgnoredFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserModuleNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserSpecificFilePathsNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserUnversionedFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesViewModelBuilder;
import com.intellij.openapi.vcs.changes.ui.NoneChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vcs.changes.ui.TagChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.VirtualFileHierarchicalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeModelBuilder
implements ChangesViewModelBuilder {
    public static final Key<Function<StaticFilePath, ChangesBrowserNode<?>>> PATH_NODE_BUILDER = Key.create((String)"ChangesTree.PathNodeBuilder");
    public static final NotNullLazyKey<Map<String, ChangesBrowserNode<?>>, ChangesBrowserNode<?>> DIRECTORY_CACHE = NotNullLazyKey.create((String)"ChangesTree.DirectoryCache", node -> new HashMap());
    private static final Key<ChangesGroupingPolicy> GROUPING_POLICY = Key.create((String)"ChangesTree.GroupingPolicy");
    public static final Key<Boolean> IS_CACHING_ROOT = Key.create((String)"ChangesTree.IsCachingRoot");
    @Nullable
    public final Project myProject;
    @NotNull
    public final DefaultTreeModel myModel;
    @NotNull
    public final ChangesBrowserNode<?> myRoot;
    @NotNull
    private final ChangesGroupingPolicyFactory myGroupingPolicyFactory;
    private static final Comparator<ChangesBrowserNode> BROWSER_NODE_COMPARATOR = (node1, node2) -> {
        Class<?> clazz2;
        int sortWeightDiff = Comparing.compare((int)node1.getSortWeight(), (int)node2.getSortWeight());
        if (sortWeightDiff != 0) {
            return sortWeightDiff;
        }
        Class<?> clazz1 = node1.getClass();
        if (!clazz1.equals(clazz2 = node2.getClass())) {
            return Comparing.compare((Comparable)((Object)clazz1.getName()), (Comparable)((Object)clazz2.getName()));
        }
        if (node1 instanceof Comparable) {
            return ((Comparable)((Object)node1)).compareTo(node2);
        }
        return node1.compareUserObjects(node2.getUserObject());
    };
    public static final Comparator<FilePath> PATH_COMPARATOR = Comparator.comparingInt(path2 -> path2.getPath().length());
    public static final Comparator<Change> CHANGE_COMPARATOR = Comparator.comparing(ChangesUtil::getFilePath, PATH_COMPARATOR);

    @Deprecated
    public TreeModelBuilder(@NotNull Project project, boolean showFlatten) {
        this(project, ChangesGroupingSupport.getFactory(showFlatten ? "none" : "directory"));
    }

    public TreeModelBuilder(@Nullable Project project, @NotNull ChangesGroupingPolicyFactory grouping2) {
        this.myProject = project != null && !project.isDefault() ? project : null;
        this.myRoot = ChangesBrowserNode.createRoot();
        this.myModel = new DefaultTreeModel(this.myRoot);
        this.myGroupingPolicyFactory = grouping2;
    }

    @NotNull
    public static DefaultTreeModel buildEmpty() {
        return new DefaultTreeModel(ChangesBrowserNode.createRoot());
    }

    @Deprecated
    @NotNull
    public static DefaultTreeModel buildFromChanges(@NotNull Project project, boolean showFlatten, @NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        return new TreeModelBuilder(project, showFlatten).setChanges(changes, changeNodeDecorator).build();
    }

    @NotNull
    public static DefaultTreeModel buildFromChanges(@Nullable Project project, @NotNull ChangesGroupingPolicyFactory grouping2, @NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        return new TreeModelBuilder(project, grouping2).setChanges(changes, changeNodeDecorator).build();
    }

    @NotNull
    public static DefaultTreeModel buildFromFilePaths(@Nullable Project project, @NotNull ChangesGroupingPolicyFactory grouping2, @NotNull Collection<? extends FilePath> filePaths) {
        return new TreeModelBuilder(project, grouping2).setFilePaths(filePaths).build();
    }

    @NotNull
    public static DefaultTreeModel buildFromChangeLists(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping2, @NotNull Collection<? extends ChangeList> changeLists) {
        return TreeModelBuilder.buildFromChangeLists(project, grouping2, changeLists, false);
    }

    @NotNull
    public static DefaultTreeModel buildFromChangeLists(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping2, @NotNull Collection<? extends ChangeList> changeLists, boolean skipSingleDefaultChangelist) {
        return new TreeModelBuilder(project, grouping2).setChangeLists(changeLists, skipSingleDefaultChangelist, null).build();
    }

    @NotNull
    public static DefaultTreeModel buildFromVirtualFiles(@Nullable Project project, @NotNull ChangesGroupingPolicyFactory grouping2, @NotNull Collection<? extends VirtualFile> virtualFiles) {
        return new TreeModelBuilder(project, grouping2).setVirtualFiles(virtualFiles, null).build();
    }

    @NotNull
    public TreeModelBuilder setChanges(@NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        return this.setChanges(changes, changeNodeDecorator, null);
    }

    @NotNull
    public TreeModelBuilder setChanges(@NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator, @Nullable Object tag) {
        this.insertChanges(changes, this.createTagNode(tag), changeNodeDecorator);
        return this;
    }

    @Override
    public void insertChanges(@NotNull Collection<? extends Change> changes, @NotNull ChangesBrowserNode<?> subtreeRoot) {
        this.insertChanges(changes, subtreeRoot, null);
    }

    public void insertChanges(@NotNull Collection<? extends Change> changes, @NotNull ChangesBrowserNode<?> subtreeRoot, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        for (Change change : ContainerUtil.sorted(changes, CHANGE_COMPARATOR)) {
            this.insertChangeNode(change, subtreeRoot, this.createChangeNode(change, changeNodeDecorator));
        }
    }

    @NotNull
    public TreeModelBuilder setUnversioned(@Nullable List<FilePath> unversionedFiles) {
        assert (this.myProject != null);
        if (ContainerUtil.isEmpty(unversionedFiles)) {
            return this;
        }
        ChangesBrowserUnversionedFilesNode node = new ChangesBrowserUnversionedFilesNode(this.myProject, unversionedFiles);
        return this.insertSpecificFilePathNodeToModel(unversionedFiles, node, FileStatus.UNKNOWN);
    }

    @NotNull
    public TreeModelBuilder setIgnored(@Nullable List<FilePath> ignoredFiles, boolean updatingMode) {
        assert (this.myProject != null);
        if (ContainerUtil.isEmpty(ignoredFiles)) {
            return this;
        }
        ChangesBrowserIgnoredFilesNode node = new ChangesBrowserIgnoredFilesNode(this.myProject, ignoredFiles, updatingMode);
        return this.insertSpecificFilePathNodeToModel(ignoredFiles, node, FileStatus.IGNORED);
    }

    @NotNull
    private TreeModelBuilder insertSpecificFilePathNodeToModel(@NotNull List<? extends FilePath> specificFiles, @NotNull ChangesBrowserSpecificFilePathsNode node, @NotNull FileStatus status) {
        this.insertSubtreeRoot((ChangesBrowserNode)node);
        if (!node.isManyFiles()) {
            node.markAsHelperNode();
            this.insertLocalFilePathIntoNode(specificFiles, node, status);
        }
        return this;
    }

    @NotNull
    public TreeModelBuilder setChangeLists(@NotNull Collection<? extends ChangeList> changeLists, boolean skipSingleDefaultChangeList, @Nullable Function<ChangeNodeDecorator, ChangeNodeDecorator> changeDecoratorProvider) {
        assert (this.myProject != null);
        RemoteRevisionsCache revisionsCache = RemoteRevisionsCache.getInstance(this.myProject);
        boolean skipChangeListNode = skipSingleDefaultChangeList && TreeModelBuilder.isSingleBlankChangeList(changeLists);
        for (ChangeList changeList : changeLists) {
            ChangesBrowserChangeListNode changesParent;
            List changes = ContainerUtil.sorted((Collection)changeList.getChanges(), CHANGE_COMPARATOR);
            ChangeListRemoteState listRemoteState = new ChangeListRemoteState(changes.size());
            if (!skipChangeListNode) {
                ChangesBrowserChangeListNode listNode = new ChangesBrowserChangeListNode(this.myProject, changeList, listRemoteState);
                listNode.markAsHelperNode();
                this.insertSubtreeRoot((ChangesBrowserNode)listNode);
                changesParent = listNode;
            } else {
                changesParent = this.myRoot;
            }
            for (int i = 0; i < changes.size(); ++i) {
                Change change = (Change)changes.get(i);
                RemoteStatusChangeNodeDecorator baseDecorator = new RemoteStatusChangeNodeDecorator(revisionsCache, listRemoteState, i);
                RemoteStatusChangeNodeDecorator decorator = changeDecoratorProvider != null ? changeDecoratorProvider.apply(baseDecorator) : baseDecorator;
                this.insertChangeNode(change, changesParent, this.createChangeNode(change, decorator));
            }
        }
        return this;
    }

    private static boolean isSingleBlankChangeList(Collection<? extends ChangeList> lists) {
        if (lists.size() != 1) {
            return false;
        }
        ChangeList single = lists.iterator().next();
        if (!(single instanceof LocalChangeList)) {
            return false;
        }
        return ((LocalChangeList)single).isBlank();
    }

    @NotNull
    public ChangesBrowserNode<?> createChangeNode(@NotNull Change change, @Nullable ChangeNodeDecorator decorator) {
        return new ChangesBrowserChangeNode(this.myProject, change, decorator);
    }

    @NotNull
    public TreeModelBuilder setLockedFolders(@Nullable List<? extends VirtualFile> lockedFolders) {
        assert (this.myProject != null);
        if (ContainerUtil.isEmpty(lockedFolders)) {
            return this;
        }
        this.insertFilesIntoNode(lockedFolders, ChangesBrowserNode.createLockedFolders(this.myProject));
        return this;
    }

    @NotNull
    public TreeModelBuilder setModifiedWithoutEditing(@NotNull List<? extends VirtualFile> modifiedWithoutEditing) {
        return this.setVirtualFiles(modifiedWithoutEditing, ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG);
    }

    @NotNull
    private TreeModelBuilder setVirtualFiles(@Nullable Collection<? extends VirtualFile> files, @Nullable Object tag) {
        if (ContainerUtil.isEmpty(files)) {
            return this;
        }
        this.insertFilesIntoNode(files, this.createTagNode(tag));
        return this;
    }

    @NotNull
    public ChangesBrowserNode<?> createTagNode(@Nullable Object tag) {
        return this.createTagNode(tag, true);
    }

    @NotNull
    public ChangesBrowserNode<?> createTagNode(@Nullable Object tag, boolean expandByDefault) {
        if (tag == null) {
            return this.myRoot;
        }
        TagChangesBrowserNode subtreeRoot = new TagChangesBrowserNode(tag, expandByDefault);
        subtreeRoot.markAsHelperNode();
        this.insertSubtreeRoot((ChangesBrowserNode)subtreeRoot);
        return subtreeRoot;
    }

    @Override
    public void insertFilesIntoNode(@NotNull Collection<? extends VirtualFile> files, @NotNull ChangesBrowserNode<?> subtreeRoot) {
        List sortedFiles = ContainerUtil.sorted(files, (Comparator)VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile file : sortedFiles) {
            this.insertChangeNode(file, subtreeRoot, ChangesBrowserNode.createFile(this.myProject, file));
        }
    }

    private void insertLocalFilePathIntoNode(@NotNull Collection<? extends FilePath> files, @NotNull ChangesBrowserNode<?> subtreeRoot, @NotNull FileStatus status) {
        List sortedFilePaths = ContainerUtil.sorted(files, PATH_COMPARATOR);
        for (FilePath filePath : sortedFilePaths) {
            this.insertChangeNode(filePath, subtreeRoot, ChangesBrowserNode.createFilePath(filePath, status));
        }
    }

    @NotNull
    public TreeModelBuilder setLocallyDeletedPaths(@Nullable Collection<? extends LocallyDeletedChange> locallyDeletedChanges) {
        if (ContainerUtil.isEmpty(locallyDeletedChanges)) {
            return this;
        }
        ChangesBrowserNode<?> subtreeRoot = this.createTagNode(ChangesBrowserNode.LOCALLY_DELETED_NODE_TAG);
        for (LocallyDeletedChange change : ContainerUtil.sorted(locallyDeletedChanges, Comparator.comparing(LocallyDeletedChange::getPath, PATH_COMPARATOR))) {
            this.insertChangeNode(change, subtreeRoot, ChangesBrowserNode.createLocallyDeleted(change));
        }
        return this;
    }

    @NotNull
    public TreeModelBuilder setFilePaths(@NotNull Collection<? extends FilePath> filePaths) {
        return this.setFilePaths(filePaths, this.myRoot);
    }

    @NotNull
    public TreeModelBuilder setFilePaths(@NotNull Collection<? extends FilePath> filePaths, @NotNull ChangesBrowserNode<?> subtreeRoot) {
        for (FilePath file : ContainerUtil.sorted(filePaths, PATH_COMPARATOR)) {
            assert (file != null);
            this.insertChangeNode(file, subtreeRoot, ChangesBrowserNode.createFilePath(file));
        }
        return this;
    }

    @NotNull
    public TreeModelBuilder setSwitchedRoots(@Nullable Map<VirtualFile, String> switchedRoots) {
        if (ContainerUtil.isEmpty(switchedRoots)) {
            return this;
        }
        ChangesBrowserNode<?> rootsHeadNode = this.createTagNode(ChangesBrowserNode.SWITCHED_ROOTS_TAG);
        rootsHeadNode.setAttributes(SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        List files = ContainerUtil.sorted(switchedRoots.keySet(), (Comparator)VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile vf : files) {
            CurrentContentRevision cr = new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)vf));
            Change change = new Change((ContentRevision)cr, (ContentRevision)cr, FileStatus.NOT_CHANGED);
            final String branchName = switchedRoots.get(vf);
            this.insertChangeNode(vf, rootsHeadNode, this.createChangeNode(change, new ChangeNodeDecorator(){

                @Override
                public void decorate(@NotNull Change change1, @NotNull SimpleColoredComponent component, boolean isShowFlatten) {
                }

                @Override
                public void preDecorate(@NotNull Change change1, @NotNull ChangesBrowserNodeRenderer renderer, boolean showFlatten) {
                    renderer.append("[" + branchName + "] ", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
                }
            }));
        }
        return this;
    }

    @NotNull
    public TreeModelBuilder setSwitchedFiles(@NotNull MultiMap<String, VirtualFile> switchedFiles) {
        if (switchedFiles.isEmpty()) {
            return this;
        }
        ChangesBrowserNode<?> subtreeRoot = this.createTagNode(ChangesBrowserNode.SWITCHED_FILES_TAG);
        for (String branchName : switchedFiles.keySet()) {
            List switchedFileList = ContainerUtil.sorted((Collection)switchedFiles.get((Object)branchName), (Comparator)VirtualFileHierarchicalComparator.getInstance());
            if (switchedFileList.size() <= 0) continue;
            ChangesBrowserNode branchNode = ChangesBrowserNode.createObject(branchName);
            branchNode.markAsHelperNode();
            this.insertSubtreeRoot(branchNode, subtreeRoot);
            for (VirtualFile file : switchedFileList) {
                this.insertChangeNode(file, branchNode, ChangesBrowserNode.createFile(this.myProject, file));
            }
        }
        return this;
    }

    @NotNull
    public TreeModelBuilder setLogicallyLockedFiles(@Nullable Map<VirtualFile, LogicalLock> logicallyLockedFiles) {
        if (ContainerUtil.isEmpty(logicallyLockedFiles)) {
            return this;
        }
        ChangesBrowserNode<?> subtreeRoot = this.createTagNode(ChangesBrowserNode.LOGICALLY_LOCKED_TAG);
        List keys = ContainerUtil.sorted(logicallyLockedFiles.keySet(), (Comparator)VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile file : keys) {
            LogicalLock lock = logicallyLockedFiles.get(file);
            this.insertChangeNode(file, subtreeRoot, ChangesBrowserNode.createLogicallyLocked(this.myProject, file, lock));
        }
        return this;
    }

    @Override
    @NotNull
    public TreeModelBuilder insertSubtreeRoot(@NotNull ChangesBrowserNode<?> node) {
        this.insertSubtreeRoot(node, this.myRoot);
        return this;
    }

    @NotNull
    public TreeModelBuilder insertSubtreeRoot(@NotNull ChangesBrowserNode<?> node, @NotNull ChangesBrowserNode<?> subtreeRoot) {
        this.myModel.insertNodeInto(node, subtreeRoot, subtreeRoot.getChildCount());
        return this;
    }

    public void insertChangeNode(@NotNull Object change, @NotNull ChangesBrowserNode<?> subtreeRoot, @NotNull ChangesBrowserNode<?> node) {
        this.insertChangeNode(change, subtreeRoot, node, TreeModelBuilder::createPathNode);
    }

    protected void insertChangeNode(@NotNull Object change, @NotNull ChangesBrowserNode<?> subtreeRoot, @NotNull ChangesBrowserNode<?> node, @NotNull Function<StaticFilePath, ChangesBrowserNode<?>> nodeBuilder) {
        PATH_NODE_BUILDER.set(subtreeRoot, nodeBuilder);
        if (!GROUPING_POLICY.isIn(subtreeRoot)) {
            NoneChangesGroupingPolicy policy = this.myProject != null ? this.myGroupingPolicyFactory.createGroupingPolicy(this.myProject, this.myModel) : NoneChangesGroupingPolicy.INSTANCE;
            GROUPING_POLICY.set(subtreeRoot, (Object)policy);
        }
        StaticFilePath pathKey = TreeModelBuilder.getKey(change);
        ChangesBrowserNode parentNode = (ChangesBrowserNode)ReadAction.compute(() -> (ChangesBrowserNode)ObjectUtils.notNull((Object)((ChangesGroupingPolicy)GROUPING_POLICY.getRequired((UserDataHolder)subtreeRoot)).getParentNodeFor(pathKey, subtreeRoot), (Object)subtreeRoot));
        ChangesBrowserNode<?> cachingRoot = BaseChangesGroupingPolicy.getCachingRoot(parentNode, subtreeRoot);
        this.myModel.insertNodeInto(node, parentNode, this.myModel.getChildCount(parentNode));
        if (pathKey.isDirectory()) {
            ((Map)DIRECTORY_CACHE.getValue(cachingRoot)).put(pathKey.getKey(), node);
        }
    }

    @NotNull
    public DefaultTreeModel build() {
        TreeUtil.sort((DefaultTreeModel)this.myModel, BROWSER_NODE_COMPARATOR);
        TreeModelBuilder.collapseDirectories(this.myModel, this.myRoot);
        this.myModel.nodeStructureChanged((TreeNode)this.myModel.getRoot());
        return this.myModel;
    }

    private static void collapseDirectories(@NotNull DefaultTreeModel model, @NotNull ChangesBrowserNode<?> node) {
        ChangesBrowserNode child;
        ChangesBrowserNode<?> collapsed;
        ChangesBrowserNode<?> collapsedNode = node;
        while (collapsedNode.getChildCount() == 1 && (collapsed = TreeModelBuilder.collapseParentWithOnlyChild(collapsedNode, child = (ChangesBrowserNode)collapsedNode.getChildAt(0))) != null) {
            collapsedNode = collapsed;
        }
        if (collapsedNode != node) {
            TreeNode parent = node.getParent();
            int idx = ((DefaultMutableTreeNode)parent).getIndex(node);
            model.removeNodeFromParent(node);
            model.insertNodeInto(collapsedNode, (MutableTreeNode)parent, idx);
            node = collapsedNode;
        }
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            ChangesBrowserNode child2 = (ChangesBrowserNode)children.nextElement();
            TreeModelBuilder.collapseDirectories(model, child2);
        }
    }

    @Nullable
    private static ChangesBrowserNode<?> collapseParentWithOnlyChild(@NotNull ChangesBrowserNode<?> parent, @NotNull ChangesBrowserNode<?> child) {
        if (child.isLeaf()) {
            return null;
        }
        Object parentUserObject = parent.getUserObject();
        Object childUserObject = child.getUserObject();
        if (parentUserObject instanceof FilePath && childUserObject instanceof FilePath) {
            return child;
        }
        if (parent instanceof ChangesBrowserModuleNode && childUserObject instanceof FilePath) {
            FilePath childPath;
            FilePath parentPath = ((ChangesBrowserModuleNode)parent).getModuleRoot();
            if (!parentPath.equals(childPath = (FilePath)childUserObject)) {
                return null;
            }
            parent.remove(0);
            Enumeration<TreeNode> children = child.children();
            for (ChangesBrowserNode childNode : ContainerUtil.toList(children)) {
                parent.add(childNode);
            }
            return parent;
        }
        return null;
    }

    @NotNull
    private static StaticFilePath getKey(@NotNull Object o) {
        if (o instanceof Change) {
            return TreeModelBuilder.staticFrom(ChangesUtil.getFilePath((Change)((Change)o)));
        }
        if (o instanceof VirtualFile) {
            return TreeModelBuilder.staticFrom((VirtualFile)o);
        }
        if (o instanceof FilePath) {
            return TreeModelBuilder.staticFrom((FilePath)o);
        }
        if (o instanceof LocallyDeletedChange) {
            return TreeModelBuilder.staticFrom(((LocallyDeletedChange)o).getPath());
        }
        throw new IllegalArgumentException("Unknown type - " + o.getClass());
    }

    @NotNull
    public static StaticFilePath staticFrom(@NotNull FilePath fp) {
        return new StaticFilePath(fp.isDirectory(), fp.getPath(), fp.getVirtualFile());
    }

    @NotNull
    public static StaticFilePath staticFrom(@NotNull VirtualFile vf) {
        return new StaticFilePath(vf.isDirectory(), vf.getPath(), vf);
    }

    @NotNull
    public static FilePath getPathForObject(@NotNull Object o) {
        if (o instanceof Change) {
            return ChangesUtil.getFilePath((Change)((Change)o));
        }
        if (o instanceof VirtualFile) {
            return VcsUtil.getFilePath((VirtualFile)((VirtualFile)o));
        }
        if (o instanceof FilePath) {
            return (FilePath)o;
        }
        if (o instanceof LocallyDeletedChange) {
            return ((LocallyDeletedChange)o).getPath();
        }
        throw new IllegalArgumentException("Unknown type - " + o.getClass());
    }

    @NotNull
    private static ChangesBrowserNode<?> createPathNode(@NotNull StaticFilePath path2) {
        FilePath filePath = VcsUtil.getFilePath((String)path2.getPath(), (boolean)path2.isDirectory());
        return ChangesBrowserNode.createFilePath(filePath);
    }

    public boolean isEmpty() {
        return this.myModel.getChildCount(this.myRoot) == 0;
    }

    @Deprecated
    @NotNull
    public DefaultTreeModel buildModel(@NotNull List<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        return this.setChanges(changes, changeNodeDecorator).build();
    }
}

