/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.ex.ThreeStateCheckboxAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.UnversionedViewDialog;
import com.intellij.openapi.vcs.changes.actions.RollbackDialogAction;
import com.intellij.openapi.vcs.changes.actions.diff.UnversionedDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserUnversionedFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.CommitDialogChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.EditSourceForDialogAction;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcs.commit.PartialCommitChangeNodeDecorator;
import com.intellij.vcs.commit.PartialCommitInclusionModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MultipleLocalChangeListsBrowser
extends CommitDialogChangesBrowser
implements Disposable {
    @NotNull
    private final MergingUpdateQueue myUpdateQueue = new MergingUpdateQueue("MultipleLocalChangeListsBrowser", 300, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this);
    private final boolean myEnableUnversioned;
    private final boolean myEnablePartialCommit;
    @Nullable
    private Supplier<? extends JComponent> myBottomDiffComponent;
    @NotNull
    private final ChangeListChooser myChangeListChooser;
    @NotNull
    private final DeleteProvider myDeleteProvider = new VirtualFileDeleteProvider();
    @NotNull
    private final PartialCommitInclusionModel myInclusionModel;
    @NotNull
    private LocalChangeList myChangeList;
    private final List<Change> myChanges = new ArrayList<Change>();
    private final List<FilePath> myUnversioned = new ArrayList<FilePath>();
    private boolean myHasHiddenUnversioned;
    @Nullable
    private Runnable mySelectedListChangeListener;
    private final RollbackDialogAction myRollbackDialogAction;

    MultipleLocalChangeListsBrowser(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems, boolean enableUnversioned, boolean enablePartialCommit) {
        super(project, showCheckboxes, highlightProblems);
        List allChangeLists;
        this.myEnableUnversioned = enableUnversioned;
        this.myEnablePartialCommit = enablePartialCommit;
        this.myChangeList = ChangeListManager.getInstance((Project)project).getDefaultChangeList();
        this.myChangeListChooser = new ChangeListChooser();
        this.myRollbackDialogAction = new RollbackDialogAction();
        this.myRollbackDialogAction.registerCustomShortcutSet(this, null);
        if (Registry.is((String)"vcs.skip.single.default.changelist") && (allChangeLists = ChangeListManager.getInstance((Project)project).getChangeLists()).size() == 1 && ((LocalChangeList)allChangeLists.get(0)).isBlank()) {
            this.myChangeListChooser.setVisible(false);
        }
        this.myInclusionModel = new PartialCommitInclusionModel(this.myProject);
        Disposer.register((Disposable)this, (Disposable)this.myInclusionModel);
        this.getViewer().setInclusionModel(this.myInclusionModel);
        ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)new MyChangeListListener(), (Disposable)this);
        this.init();
        this.updateDisplayedChangeLists();
        this.updateSelectedChangeList(this.myChangeList);
    }

    @Override
    @Nullable
    protected JComponent createHeaderPanel() {
        return JBUI.Panels.simplePanel((Component)this.myChangeListChooser).withBorder((Border)JBUI.Borders.emptyLeft((int)6));
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        AnAction rollbackGroup = this.createRollbackGroup(true);
        return ContainerUtil.append(super.createToolbarActions(), (Object[])new AnAction[]{rollbackGroup, ActionManager.getInstance().getAction("ChangesView.Refresh"), ActionManager.getInstance().getAction("Vcs.CheckinProjectToolbar")});
    }

    private AnAction createRollbackGroup(boolean popup) {
        List<? extends AnAction> rollbackActions = this.createAdditionalRollbackActions();
        if (rollbackActions.isEmpty()) {
            return this.myRollbackDialogAction;
        }
        DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{this.myRollbackDialogAction});
        group.addAll(rollbackActions);
        ActionUtil.copyFrom((AnAction)group, (String)"ChangesView.Revert");
        group.setPopup(popup);
        return group;
    }

    protected List<? extends AnAction> createAdditionalRollbackActions() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupMenuActions() {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>(super.createPopupMenuActions());
        result2.add(ActionManager.getInstance().getAction("ChangesView.Refresh"));
        if (this.myEnableUnversioned) {
            result2.add((AnAction)new ShowHideUnversionedFilesAction());
            result2.add((AnAction)UnversionedViewDialog.registerUnversionedPopupGroup((JComponent)((Object)this.myViewer)));
        } else {
            result2.add(ActionManager.getInstance().getAction("ChangesView.Move"));
        }
        EmptyAction.registerWithShortcutSet((String)"ChangesView.Move", (ShortcutSet)CommonShortcuts.getMove(), (JComponent)((Object)this.myViewer));
        result2.add(this.createRollbackGroup(false));
        EditSourceForDialogAction editSourceAction = new EditSourceForDialogAction(this);
        editSourceAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this);
        result2.add((AnAction)editSourceAction);
        result2.add(ActionManager.getInstance().getAction("Vcs.CheckinProjectMenu"));
        return result2;
    }

    @Override
    @NotNull
    protected List<AnAction> createDiffActions() {
        return ContainerUtil.append(super.createDiffActions(), (Object[])new AnAction[]{new ToggleChangeDiffAction()});
    }

    @Override
    protected void updateDiffContext(@NotNull DiffRequestChain chain) {
        super.updateDiffContext(chain);
        if (this.myBottomDiffComponent != null) {
            chain.putUserData(DiffUserDataKeysEx.BOTTOM_PANEL, (Object)this.myBottomDiffComponent.get());
        }
        chain.putUserData(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, (Object)this.myEnablePartialCommit);
        chain.putUserData(DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL, (Object)true);
    }

    public void setBottomDiffComponent(@Nullable Supplier<? extends JComponent> value) {
        this.myBottomDiffComponent = value;
    }

    public void setSelectedListChangeListener(@Nullable Runnable runnable) {
        this.mySelectedListChangeListener = runnable;
    }

    private boolean isShowUnversioned() {
        return this.myEnableUnversioned && VcsConfiguration.getInstance((Project)this.myProject).SHOW_UNVERSIONED_FILES_WHILE_COMMIT;
    }

    private void setShowUnversioned(boolean value) {
        VcsConfiguration.getInstance((Project)this.myProject).SHOW_UNVERSIONED_FILES_WHILE_COMMIT = value;
        this.updateDisplayedChanges();
    }

    @Override
    @NotNull
    public LocalChangeList getSelectedChangeList() {
        return this.myChangeList;
    }

    public void setSelectedChangeList(@NotNull LocalChangeList list) {
        this.myChangeListChooser.setSelectedChangeList(list);
    }

    private void updateSelectedChangeList(@NotNull LocalChangeList list) {
        boolean isListChanged;
        boolean bl = isListChanged = !this.myChangeList.getId().equals(list.getId());
        if (isListChanged) {
            LineStatusTrackerManager.getInstanceImpl(this.myProject).resetExcludedFromCommitMarkers();
        }
        this.myChangeList = list;
        this.myChangeListChooser.setToolTipText(list.getName());
        this.updateDisplayedChanges();
        if (isListChanged && this.mySelectedListChangeListener != null) {
            this.mySelectedListChangeListener.run();
        }
        this.myInclusionModel.setChangeLists((Collection<? extends LocalChangeList>)ContainerUtil.immutableSingletonList((Object)this.myChangeList));
    }

    @Override
    public void updateDisplayedChangeLists() {
        List changeLists = ChangeListManager.getInstance((Project)this.myProject).getChangeLists();
        this.myChangeListChooser.setAvailableLists(changeLists);
    }

    public void updateDisplayedChanges() {
        this.myChanges.clear();
        this.myUnversioned.clear();
        this.myHasHiddenUnversioned = false;
        this.myChanges.addAll(this.myChangeList.getChanges());
        if (this.myEnableUnversioned) {
            List<FilePath> unversioned = ChangeListManagerImpl.getInstanceImpl(this.myProject).getUnversionedFilesPaths();
            if (this.isShowUnversioned()) {
                this.myUnversioned.addAll(unversioned);
            }
            if (!this.isShowUnversioned() && !unversioned.isEmpty()) {
                this.myHasHiddenUnversioned = true;
            }
        }
        this.myViewer.rebuildTree();
    }

    @Override
    @NotNull
    protected DefaultTreeModel buildTreeModel() {
        PartialCommitChangeNodeDecorator decorator = new PartialCommitChangeNodeDecorator(this.myProject, RemoteRevisionsCache.getInstance(this.myProject).getChangesNodeDecorator());
        TreeModelBuilder builder = new TreeModelBuilder(this.myProject, this.getGrouping());
        builder.setChanges(this.myChanges, decorator);
        builder.setUnversioned(this.myUnversioned);
        if (this.myHasHiddenUnversioned) {
            this.myViewer.getEmptyText().setText(VcsBundle.message((String)"status.text.unversioned.files.available", (Object[])new Object[0])).appendText(VcsBundle.message((String)"plugins.configurable.show", (Object[])new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, e -> this.setShowUnversioned(true));
        } else {
            this.myViewer.getEmptyText().setText(DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{0}));
        }
        return builder.build();
    }

    @Override
    @Nullable
    protected ChangeDiffRequestChain.Producer getDiffRequestProducer(@NotNull Object entry) {
        if (entry instanceof FilePath) {
            return UnversionedDiffRequestProducer.create(this.myProject, (FilePath)entry);
        }
        return super.getDiffRequestProducer(entry);
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (ChangesListView.UNVERSIONED_FILE_PATHS_DATA_KEY.is(dataId)) {
            return ChangesListView.getSelectedUnversionedFiles((JTree)((Object)this.myViewer));
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.myDeleteProvider;
        }
        if (VcsDataKeys.CHANGE_LISTS.is(dataId)) {
            return new ChangeList[]{this.myChangeList};
        }
        if (ChangesListView.EXACTLY_SELECTED_FILES_DATA_KEY.is(dataId)) {
            return ChangesListView.getExactlySelectedVirtualFiles((JTree)((Object)this.myViewer));
        }
        return super.getData(dataId);
    }

    @Override
    @NotNull
    public List<Change> getDisplayedChanges() {
        return VcsTreeModelData.all((JTree)((Object)this.myViewer)).userObjects(Change.class);
    }

    @Override
    @NotNull
    public List<Change> getSelectedChanges() {
        return VcsTreeModelData.selected((JTree)((Object)this.myViewer)).userObjects(Change.class);
    }

    @Override
    @NotNull
    public List<Change> getIncludedChanges() {
        return VcsTreeModelData.included(this.myViewer).userObjects(Change.class);
    }

    @Override
    @NotNull
    public List<FilePath> getDisplayedUnversionedFiles() {
        if (!this.isShowUnversioned()) {
            return Collections.emptyList();
        }
        VcsTreeModelData treeModelData = VcsTreeModelData.allUnderTag((JTree)((Object)this.myViewer), ChangesBrowserNode.UNVERSIONED_FILES_TAG);
        if (MultipleLocalChangeListsBrowser.containsCollapsedUnversionedNode(treeModelData)) {
            return ContainerUtil.newUnmodifiableList(this.myUnversioned);
        }
        return treeModelData.userObjects(FilePath.class);
    }

    @Override
    @NotNull
    public List<FilePath> getSelectedUnversionedFiles() {
        if (!this.isShowUnversioned()) {
            return Collections.emptyList();
        }
        VcsTreeModelData treeModelData = VcsTreeModelData.selectedUnderTag((JTree)((Object)this.myViewer), ChangesBrowserNode.UNVERSIONED_FILES_TAG);
        if (MultipleLocalChangeListsBrowser.containsCollapsedUnversionedNode(treeModelData)) {
            return ContainerUtil.newUnmodifiableList(this.myUnversioned);
        }
        return treeModelData.userObjects(FilePath.class);
    }

    @Override
    @NotNull
    public List<FilePath> getIncludedUnversionedFiles() {
        if (!this.isShowUnversioned()) {
            return Collections.emptyList();
        }
        VcsTreeModelData treeModelData = VcsTreeModelData.includedUnderTag(this.myViewer, ChangesBrowserNode.UNVERSIONED_FILES_TAG);
        if (MultipleLocalChangeListsBrowser.containsCollapsedUnversionedNode(treeModelData)) {
            return ContainerUtil.newUnmodifiableList(this.myUnversioned);
        }
        return treeModelData.userObjects(FilePath.class);
    }

    private static boolean containsCollapsedUnversionedNode(@NotNull VcsTreeModelData treeModelData) {
        Optional<ChangesBrowserNode> node = treeModelData.nodesStream().filter(it -> it instanceof ChangesBrowserUnversionedFilesNode).findAny();
        if (!node.isPresent()) {
            return false;
        }
        ChangesBrowserUnversionedFilesNode unversionedFilesNode = (ChangesBrowserUnversionedFilesNode)node.get();
        return unversionedFilesNode.isManyFiles();
    }

    private class MyChangeListListener
    extends ChangeListAdapter {
        private MyChangeListListener() {
        }

        public void changeListsChanged() {
            MultipleLocalChangeListsBrowser.this.myUpdateQueue.queue(new Update("updateChangeLists"){

                public void run() {
                    MultipleLocalChangeListsBrowser.this.updateDisplayedChangeLists();
                }
            });
        }
    }

    private class ToggleChangeDiffAction
    extends ThreeStateCheckboxAction
    implements CustomComponentAction,
    DumbAware {
        ToggleChangeDiffAction() {
            super(VcsBundle.messagePointer((String)"commit.dialog.include.action.name", (Object[])new Object[0]));
        }

        @NotNull
        public ThreeStateCheckBox.State isSelected(AnActionEvent e) {
            Object object = this.getUserObject(e);
            if (object == null) {
                return ThreeStateCheckBox.State.NOT_SELECTED;
            }
            return MultipleLocalChangeListsBrowser.this.myInclusionModel.getInclusionState(object);
        }

        public void setSelected(AnActionEvent e, @NotNull ThreeStateCheckBox.State state) {
            Object object = this.getUserObject(e);
            if (object == null) {
                return;
            }
            if (state != ThreeStateCheckBox.State.NOT_SELECTED) {
                MultipleLocalChangeListsBrowser.this.myViewer.includeChange(object);
            } else {
                MultipleLocalChangeListsBrowser.this.myViewer.excludeChange(object);
            }
        }

        @Nullable
        private Object getUserObject(@NotNull AnActionEvent e) {
            Object object = e.getData(VcsDataKeys.CURRENT_CHANGE);
            if (object == null) {
                object = e.getData(VcsDataKeys.CURRENT_UNVERSIONED);
            }
            return object;
        }
    }

    private class ShowHideUnversionedFilesAction
    extends ToggleAction
    implements DumbAware {
        private ShowHideUnversionedFilesAction() {
            super(VcsBundle.messagePointer((String)"action.ToggleAction.text.show.unversioned.files", (Object[])new Object[0]), Presentation.NULL_STRING, AllIcons.Vcs.ShowUnversionedFiles);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return MultipleLocalChangeListsBrowser.this.isShowUnversioned();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            MultipleLocalChangeListsBrowser.this.setShowUnversioned(state);
        }
    }

    private class ChangeListChooser
    extends JPanel {
        private static final int MAX_NAME_LEN = 35;
        @NotNull
        private final ComboBox<LocalChangeList> myChooser = new ComboBox();

        ChangeListChooser() {
            this.myChooser.setEditable(false);
            this.myChooser.setRenderer((ListCellRenderer)new ColoredListCellRenderer<LocalChangeList>(){

                protected void customizeCellRenderer(@NotNull JList<? extends LocalChangeList> list, LocalChangeList value, int index, boolean selected, boolean hasFocus) {
                    String name = StringUtil.shortenTextWithEllipsis((String)value.getName().trim(), (int)35, (int)0);
                    this.append(name, value.isDefault() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            });
            this.myChooser.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    LocalChangeList changeList;
                    if (e.getStateChange() == 1 && (changeList = (LocalChangeList)ChangeListChooser.this.myChooser.getSelectedItem()) != null) {
                        MultipleLocalChangeListsBrowser.this.updateSelectedChangeList(changeList);
                    }
                }
            });
            this.setLayout(new BorderLayout(4, 2));
            JLabel label = new JLabel(VcsBundle.message((String)"commit.dialog.changelist.label", (Object[])new Object[0]));
            label.setLabelFor((Component)this.myChooser);
            this.add((Component)label, "West");
            this.add((Component)this.myChooser, "Center");
        }

        public void setAvailableLists(@NotNull List<LocalChangeList> lists) {
            LocalChangeList currentList = (LocalChangeList)ContainerUtil.find(lists, (Object)MultipleLocalChangeListsBrowser.this.getSelectedChangeList());
            if (currentList == null) {
                currentList = lists.get(0);
            }
            this.myChooser.setModel((ComboBoxModel)new CollectionComboBoxModel(lists, (Object)currentList));
            this.myChooser.setEnabled(lists.size() > 1);
            MultipleLocalChangeListsBrowser.this.updateSelectedChangeList(currentList);
        }

        public void setSelectedChangeList(@NotNull LocalChangeList list) {
            ComboBoxModel model = this.myChooser.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                LocalChangeList element = (LocalChangeList)model.getElementAt(i);
                if (!element.getName().equals(list.getName())) continue;
                this.myChooser.setSelectedIndex(i);
                MultipleLocalChangeListsBrowser.this.updateSelectedChangeList(element);
                return;
            }
        }
    }
}

