/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.treeStructure.Tree;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangesTreeDnDSupport
implements DnDDropHandler,
DnDTargetChecker {
    @NotNull
    protected final ChangesTree myTree;

    public ChangesTreeDnDSupport(@NotNull ChangesTree tree) {
        this.myTree = tree;
    }

    public void install(@NotNull Disposable disposable) {
        DnDSupport.createBuilder((JComponent)((Object)this.myTree)).setTargetChecker((DnDTargetChecker)this).setDropHandler((DnDDropHandler)this).setImageProvider(this::createDraggedImage).setBeanProvider(this::createDragStartBean).setDisposableParent(disposable).install();
    }

    @NotNull
    protected DnDImage createDraggedImage(@NotNull DnDActionInfo info) {
        int count = ChangesTreeDnDSupport.getSelectionCount(this.myTree);
        String imageText = count + " " + StringUtil.pluralize((String)"file", (int)count);
        return ChangesTreeDnDSupport.createDragImage(this.myTree, imageText);
    }

    @Nullable
    protected abstract DnDDragStartBean createDragStartBean(@NotNull DnDActionInfo var1);

    protected abstract boolean canHandleDropEvent(@NotNull DnDEvent var1, @NotNull ChangesBrowserNode<?> var2);

    public boolean update(DnDEvent aEvent) {
        boolean canHandle;
        aEvent.hideHighlighter();
        aEvent.setDropPossible(false, "");
        ChangesBrowserNode<?> dropNode = ChangesTreeDnDSupport.getDropRootNode(this.myTree, aEvent);
        boolean bl = canHandle = dropNode != null && this.canHandleDropEvent(aEvent, dropNode);
        if (!canHandle) {
            return true;
        }
        this.highlightDropNode(aEvent, dropNode);
        aEvent.setDropPossible(true);
        return false;
    }

    private void highlightDropNode(@NotNull DnDEvent aEvent, @NotNull ChangesBrowserNode<?> dropNode) {
        Rectangle tableCellRect = this.myTree.getPathBounds(new TreePath(dropNode.getPath()));
        if (tableCellRect != null && this.fitsInBounds(tableCellRect)) {
            aEvent.setHighlighting(new RelativeRectangle((Component)((Object)this.myTree), tableCellRect), 1);
        }
    }

    @Nullable
    public static ChangesBrowserNode<?> getDropRootNode(@NotNull ChangesTree tree, @NotNull DnDEvent event) {
        RelativePoint dropPoint = event.getRelativePoint();
        Point onTree = dropPoint.getPoint((Component)((Object)tree));
        TreePath dropPath = tree.getPathForLocation(onTree.x, onTree.y);
        if (dropPath == null) {
            return null;
        }
        TreeNode dropNode = (ChangesBrowserNode)dropPath.getLastPathComponent();
        while (!((DefaultMutableTreeNode)dropNode.getParent()).isRoot()) {
            dropNode = dropNode.getParent();
        }
        return dropNode;
    }

    public static boolean isCopyAction(@NotNull DnDEvent aEvent) {
        DnDAction eventAction = aEvent.getAction();
        return eventAction != null && eventAction.getActionId() == 1;
    }

    private boolean fitsInBounds(Rectangle rect) {
        Container scrollPane;
        Container container = this.myTree.getParent();
        if (container instanceof JViewport && (scrollPane = container.getParent()) instanceof JScrollPane) {
            Rectangle rectangle = SwingUtilities.convertRectangle((Component)((Object)this.myTree), rect, scrollPane.getParent());
            return scrollPane.getBounds().contains(rectangle);
        }
        return true;
    }

    @NotNull
    public static DnDImage createDragImage(@NotNull Tree tree, @NotNull String imageText) {
        Image image = (Image)DnDAwareTree.getDragImage((Tree)tree, (String)imageText, null).getFirst();
        return new DnDImage(image, new Point(-image.getWidth(null), -image.getHeight(null)));
    }

    public static int getSelectionCount(@NotNull ChangesTree tree) {
        TreePath[] paths = tree.getSelectionModel().getSelectionPaths();
        ArrayList<ChangesBrowserNode> parents = new ArrayList<ChangesBrowserNode>();
        for (TreePath path2 : paths) {
            ChangesBrowserNode node = (ChangesBrowserNode)path2.getLastPathComponent();
            if (node.isLeaf()) continue;
            parents.add(node);
        }
        int count = 0;
        block1: for (TreePath path3 : paths) {
            ChangesBrowserNode node = (ChangesBrowserNode)path3.getLastPathComponent();
            for (ChangesBrowserNode parent : parents) {
                if (!ChangesTreeDnDSupport.isChildNode(parent, node)) continue;
                continue block1;
            }
            count += node.getFileCount();
        }
        return count;
    }

    private static boolean isChildNode(ChangesBrowserNode<?> parent, ChangesBrowserNode<?> node) {
        for (TreeNode nodeParent = node.getParent(); nodeParent != null; nodeParent = ((ChangesBrowserNode)nodeParent).getParent()) {
            if (nodeParent != parent) continue;
            return true;
        }
        return false;
    }
}

