/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.InclusionListener;
import com.intellij.openapi.vcs.changes.InclusionModel;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeCopyProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeCellRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeHandlers;
import com.intellij.openapi.vcs.changes.ui.DefaultInclusionModel;
import com.intellij.openapi.vcs.changes.ui.NullInclusionModel;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangesTree
extends Tree
implements DataProvider {
    @NotNull
    protected final Project myProject;
    private boolean myShowCheckboxes;
    @Nullable
    private ClickListener myCheckBoxClickHandler;
    private final int myCheckboxWidth;
    @NotNull
    private final ChangesGroupingSupport myGroupingSupport;
    private boolean myIsModelFlat;
    @NotNull
    private InclusionModel myInclusionModel = new DefaultInclusionModel();
    @NotNull
    private final InclusionListener myInclusionModelListener = () -> {
        this.notifyInclusionListener();
        this.repaint();
    };
    @Nullable
    private Runnable myTreeInclusionListener;
    @NotNull
    private final ChangesTreeHandlers myHandlers;
    private boolean myKeepTreeState = false;
    @Deprecated
    @NonNls
    private static final String FLATTEN_OPTION_KEY = "ChangesBrowser.SHOW_FLATTEN";
    @NonNls
    private static final String GROUPING_KEYS = "ChangesTree.GroupingKeys";
    public static final String[] DEFAULT_GROUPING_KEYS = (String[])ContainerUtil.ar((Object[])new String[]{"directory", "module"});
    @NonNls
    public static final String GROUP_BY_ACTION_GROUP = "ChangesView.GroupBy";
    @NotNull
    private final CopyProvider myTreeCopyProvider;
    @NotNull
    private TreeExpander myTreeExpander = new MyTreeExpander();
    private boolean myModelUpdateInProgress;

    public ChangesTree(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
        this(project, showCheckboxes, highlightProblems, false);
    }

    protected ChangesTree(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems, boolean expandInSpeedSearch) {
        super((TreeNode)ChangesBrowserNode.createRoot());
        this.myProject = project;
        this.myShowCheckboxes = showCheckboxes;
        this.myCheckboxWidth = new JCheckBox().getPreferredSize().width;
        this.myInclusionModel.addInclusionListener(this.myInclusionModelListener);
        this.myHandlers = new ChangesTreeHandlers(this);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setOpaque(false);
        new TreeSpeedSearch((Tree)this, ChangesBrowserNode.TO_TEXT_CONVERTER, expandInSpeedSearch);
        ChangesBrowserNodeRenderer nodeRenderer = new ChangesBrowserNodeRenderer(this.myProject, this::isShowFlatten, highlightProblems);
        this.setCellRenderer(new ChangesTreeCellRenderer(nodeRenderer));
        new MyToggleSelectionAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), (JComponent)((Object)this));
        this.showCheckboxesChanged();
        this.installTreeLinkHandler(nodeRenderer);
        SmartExpander.installOn((JTree)((Object)this));
        this.myGroupingSupport = this.installGroupingSupport();
        this.setEmptyText(DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{0}));
        this.myTreeCopyProvider = new ChangesBrowserNodeCopyProvider((JTree)((Object)this));
    }

    private ClickListener installCheckBoxClickHandler() {
        ClickListener handler = new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                TreePath path2 = ChangesTree.this.getPathIfCheckBoxClicked(event.getPoint());
                if (path2 != null) {
                    ChangesTree.this.setSelectionPath(path2);
                    ChangesTree.this.toggleChanges(ChangesTree.this.getIncludableUserObjects(VcsTreeModelData.selected((JTree)((Object)ChangesTree.this))));
                }
                return false;
            }
        };
        handler.installOn((Component)((Object)this));
        return handler;
    }

    @Nullable
    TreePath getPathIfCheckBoxClicked(@NotNull Point p) {
        if (!this.myShowCheckboxes || !this.isEnabled()) {
            return null;
        }
        TreePath path2 = this.getPathForLocation(p.x, p.y);
        if (path2 == null) {
            return null;
        }
        Rectangle pathBounds = this.getPathBounds(path2);
        if (pathBounds == null) {
            return null;
        }
        Rectangle checkBoxBounds = pathBounds.getBounds();
        checkBoxBounds.setSize(this.myCheckboxWidth, checkBoxBounds.height);
        return checkBoxBounds.contains(p) && this.isIncludable(path2) ? path2 : null;
    }

    protected void installTreeLinkHandler(@NotNull ChangesBrowserNodeRenderer nodeRenderer) {
        new TreeLinkMouseListener(nodeRenderer){

            protected int getRendererRelativeX(@NotNull MouseEvent e, @NotNull JTree tree, @NotNull TreePath path2) {
                int x = super.getRendererRelativeX(e, tree, path2);
                return !ChangesTree.this.myShowCheckboxes ? x : x - ChangesTree.this.myCheckboxWidth;
            }

            public void mouseMoved(MouseEvent e) {
                if (!ChangesTree.this.isEmpty()) {
                    super.mouseMoved(e);
                }
            }
        }.installOn((Component)((Object)this));
    }

    @NotNull
    protected ChangesGroupingSupport installGroupingSupport() {
        ChangesGroupingSupport result2 = new ChangesGroupingSupport(this.myProject, (Object)this, false);
        this.migrateShowFlattenSetting();
        result2.setGroupingKeysOrSkip(ContainerUtil.set((Object[])((Object[])ObjectUtils.notNull((Object)PropertiesComponent.getInstance((Project)this.myProject).getValues(GROUPING_KEYS), (Object)DEFAULT_GROUPING_KEYS))));
        result2.addPropertyChangeListener(e -> this.changeGrouping());
        return result2;
    }

    private void migrateShowFlattenSetting() {
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        if (properties.isValueSet(FLATTEN_OPTION_KEY)) {
            properties.setValues(GROUPING_KEYS, properties.isTrueValue(FLATTEN_OPTION_KEY) ? ArrayUtilRt.EMPTY_STRING_ARRAY : DEFAULT_GROUPING_KEYS);
            properties.unsetValue(FLATTEN_OPTION_KEY);
        }
    }

    public void setEmptyText(@Nls @NotNull String emptyText) {
        this.getEmptyText().setText(emptyText);
    }

    public void addSelectionListener(@NotNull Runnable runnable) {
        this.addSelectionListener(runnable, null);
    }

    public void addSelectionListener(final @NotNull Runnable runnable, @Nullable Disposable parent) {
        TreeSelectionListener listener2 = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                runnable.run();
            }
        };
        this.addTreeSelectionListener(listener2);
        if (parent != null) {
            Disposer.register((Disposable)parent, () -> this.removeTreeSelectionListener(listener2));
        }
    }

    @Deprecated
    public void setDoubleClickHandler(@NotNull Runnable doubleClickHandler) {
        this.setDoubleClickAndEnterKeyHandler(doubleClickHandler);
    }

    public void setDoubleClickAndEnterKeyHandler(@NotNull Runnable handler) {
        this.setDoubleClickHandler((Processor<MouseEvent>)((Processor)e -> {
            handler.run();
            return true;
        }));
        this.setEnterKeyHandler((Processor<KeyEvent>)((Processor)e -> {
            handler.run();
            return true;
        }));
    }

    @Nullable
    public Processor<MouseEvent> getDoubleClickHandler() {
        return this.myHandlers.getDoubleClickHandler();
    }

    public void setDoubleClickHandler(@Nullable Processor<MouseEvent> handler) {
        this.myHandlers.setDoubleClickHandler(handler);
    }

    @Nullable
    public Processor<KeyEvent> getEnterKeyHandler() {
        return this.myHandlers.getEnterKeyHandler();
    }

    public void setEnterKeyHandler(@Nullable Processor<KeyEvent> handler) {
        this.myHandlers.setEnterKeyHandler(handler);
    }

    public void installPopupHandler(ActionGroup group) {
        PopupHandler.installUnknownPopupHandler((JComponent)((Object)this), (ActionGroup)group, (ActionManager)ActionManager.getInstance());
    }

    public JComponent getPreferredFocusedComponent() {
        return this;
    }

    public void addGroupingChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myGroupingSupport.addPropertyChangeListener(listener2);
    }

    public void removeGroupingChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myGroupingSupport.removePropertyChangeListener(listener2);
    }

    @NotNull
    public ChangesGroupingSupport getGroupingSupport() {
        return this.myGroupingSupport;
    }

    @NotNull
    public ChangesGroupingPolicyFactory getGrouping() {
        return this.getGroupingSupport().getGrouping();
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public boolean isShowFlatten() {
        return !this.myGroupingSupport.isDirectory();
    }

    public boolean isShowCheckboxes() {
        return this.myShowCheckboxes;
    }

    public void setShowCheckboxes(boolean value) {
        boolean oldValue = this.myShowCheckboxes;
        this.myShowCheckboxes = value;
        if (oldValue != value) {
            this.showCheckboxesChanged();
        }
    }

    private void showCheckboxesChanged() {
        if (this.isShowCheckboxes()) {
            this.myCheckBoxClickHandler = this.installCheckBoxClickHandler();
        } else if (this.myCheckBoxClickHandler != null) {
            this.myCheckBoxClickHandler.uninstall((Component)((Object)this));
            this.myCheckBoxClickHandler = null;
        }
        this.repaint();
    }

    private void changeGrouping() {
        PropertiesComponent.getInstance((Project)this.myProject).setValues(GROUPING_KEYS, ArrayUtilRt.toStringArray(this.getGroupingSupport().getGroupingKeys()));
        List<Object> oldSelection = VcsTreeModelData.selected((JTree)((Object)this)).userObjects();
        this.rebuildTree();
        this.setSelectedChanges(oldSelection);
    }

    private boolean isCurrentModelFlat() {
        boolean isFlat = true;
        Enumeration<TreeNode> enumeration = this.getRoot().depthFirstEnumeration();
        while (isFlat && enumeration.hasMoreElements()) {
            isFlat = ((ChangesBrowserNode)enumeration.nextElement()).getLevel() <= 1;
        }
        return isFlat;
    }

    public abstract void rebuildTree();

    protected void updateTreeModel(@NotNull DefaultTreeModel model) {
        this.myModelUpdateInProgress = true;
        try {
            ApplicationManager.getApplication().assertIsDispatchThread();
            TreeState state = null;
            if (this.myKeepTreeState) {
                state = TreeState.createOn((JTree)((Object)this), this.getRoot());
            }
            this.setModel(model);
            this.myIsModelFlat = this.isCurrentModelFlat();
            this.setShowsRootHandles(!this.myGroupingSupport.isNone() || !this.myIsModelFlat);
            if (this.myKeepTreeState) {
                state.applyTo((JTree)((Object)this), this.getRoot());
            } else {
                this.resetTreeState();
            }
        }
        finally {
            this.myModelUpdateInProgress = false;
        }
    }

    public boolean isModelUpdateInProgress() {
        return this.myModelUpdateInProgress;
    }

    protected void resetTreeState() {
        if (ChangesTree.hasAtLeastNodes(this, 30000)) {
            TreeUtil.collapseAll((JTree)((Object)this), (int)1);
            return;
        }
        this.expandDefaults();
        int selectedTreeRow = -1;
        if (this.myShowCheckboxes && !this.getIncludedSet().isEmpty()) {
            ChangesBrowserNode node;
            ChangesBrowserNode<?> root = this.getRoot();
            Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                node = (ChangesBrowserNode)enumeration.nextElement();
                if (node == root || this.getNodeStatus(node) != ThreeStateCheckBox.State.NOT_SELECTED) continue;
                this.collapsePath(new TreePath(node.getPath()));
            }
            enumeration = root.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                node = (ChangesBrowserNode)enumeration.nextElement();
                if (!node.isLeaf() || this.getNodeStatus(node) != ThreeStateCheckBox.State.SELECTED) continue;
                selectedTreeRow = this.getRowForPath(new TreePath(node.getPath()));
                break;
            }
        }
        if (selectedTreeRow >= 0) {
            this.setSelectionRow(selectedTreeRow);
        }
        TreeUtil.showRowCentered((JTree)((Object)this), (int)selectedTreeRow, (boolean)false);
    }

    private static boolean hasAtLeastNodes(@NotNull Tree tree, int nodeNumber) {
        return TreeUtil.treeTraverser((JTree)tree).traverse().take(nodeNumber).size() >= nodeNumber;
    }

    public void selectFile(@Nullable VirtualFile toSelect) {
        if (toSelect == null) {
            return;
        }
        this.selectFile(VcsUtil.getFilePath((VirtualFile)toSelect));
    }

    public void selectFile(@Nullable FilePath toSelect) {
        if (toSelect == null) {
            return;
        }
        int rowInTree = this.findRowContainingFile(this.getRoot(), toSelect);
        if (rowInTree == -1) {
            return;
        }
        this.setSelectionRow(rowInTree);
        TreeUtil.showRowCentered((JTree)((Object)this), (int)rowInTree, (boolean)false);
    }

    private int findRowContainingFile(@NotNull TreeNode root, @NotNull FilePath toSelect) {
        TreeNode targetNode = (TreeNode)TreeUtil.treeNodeTraverser((TreeNode)root).traverse(TreeTraversal.POST_ORDER_DFS).find(node -> {
            Object userObject;
            if (node instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)node).getUserObject()) instanceof Change) {
                return ChangesTree.matches((Change)userObject, toSelect);
            }
            return false;
        });
        if (targetNode != null) {
            return TreeUtil.getRowForNode((JTree)((Object)this), (DefaultMutableTreeNode)((DefaultMutableTreeNode)targetNode));
        }
        return -1;
    }

    private static boolean matches(@NotNull Change change, @NotNull FilePath toSelect) {
        return toSelect.equals(ChangesUtil.getAfterPath((Change)change)) || toSelect.equals(ChangesUtil.getBeforePath((Change)change));
    }

    @NotNull
    public ChangesBrowserNode<?> getRoot() {
        return (ChangesBrowserNode)this.getModel().getRoot();
    }

    @NotNull
    public InclusionModel getInclusionModel() {
        return this.myInclusionModel;
    }

    public void setInclusionModel(@Nullable InclusionModel inclusionModel) {
        this.myInclusionModel.removeInclusionListener(this.myInclusionModelListener);
        this.myInclusionModel = inclusionModel != null ? inclusionModel : NullInclusionModel.INSTANCE;
        this.myInclusionModel.addInclusionListener(this.myInclusionModelListener);
    }

    public void setInclusionListener(@Nullable Runnable runnable) {
        this.myTreeInclusionListener = runnable;
    }

    private void notifyInclusionListener() {
        if (this.myTreeInclusionListener != null) {
            this.myTreeInclusionListener.run();
        }
    }

    public void setIncludedChanges(@NotNull Collection<?> changes) {
        this.getInclusionModel().setInclusion(changes);
    }

    public void includeChange(@NotNull Object change) {
        this.includeChanges(Collections.singleton(change));
    }

    public void includeChanges(@NotNull Collection<?> changes) {
        this.getInclusionModel().addInclusion(changes);
    }

    public void excludeChange(@NotNull Object change) {
        this.excludeChanges(Collections.singleton(change));
    }

    public void excludeChanges(@NotNull Collection<?> changes) {
        this.getInclusionModel().removeInclusion(changes);
    }

    protected void toggleChanges(@NotNull Collection<?> changes) {
        boolean hasExcluded = false;
        for (Object item : changes) {
            if (this.getInclusionModel().getInclusionState(item) == ThreeStateCheckBox.State.SELECTED) continue;
            hasExcluded = true;
            break;
        }
        if (hasExcluded) {
            this.includeChanges(changes);
        } else {
            this.excludeChanges(changes);
        }
    }

    public boolean isIncluded(@NotNull Object change) {
        return this.getInclusionModel().getInclusionState(change) != ThreeStateCheckBox.State.NOT_SELECTED;
    }

    @NotNull
    public Set<Object> getIncludedSet() {
        return this.getInclusionModel().getInclusion();
    }

    public void expandAll() {
        TreeUtil.expandAll((JTree)((Object)this));
    }

    public void expandDefaults() {
        TreeUtil.promiseExpand((JTree)((Object)this), path2 -> {
            Object node = path2.getLastPathComponent();
            if (node instanceof ChangesBrowserNode && !((ChangesBrowserNode)node).shouldExpandByDefault()) {
                return TreeVisitor.Action.SKIP_CHILDREN;
            }
            return TreeVisitor.Action.CONTINUE;
        });
    }

    @NotNull
    public TreeExpander getTreeExpander() {
        return this.myTreeExpander;
    }

    public void setTreeExpander(@NotNull TreeExpander expander) {
        this.myTreeExpander = expander;
    }

    @Deprecated
    public AnAction[] getTreeActions() {
        return new AnAction[]{ActionManager.getInstance().getAction(GROUP_BY_ACTION_GROUP), this.createExpandAllAction(false), this.createCollapseAllAction(false)};
    }

    @NotNull
    public AnAction createExpandAllAction(boolean headerAction) {
        if (headerAction) {
            return CommonActionsManager.getInstance().createExpandAllHeaderAction(this.myTreeExpander, (JComponent)((Object)this));
        }
        return CommonActionsManager.getInstance().createExpandAllAction(this.myTreeExpander, (JComponent)((Object)this));
    }

    @NotNull
    public AnAction createCollapseAllAction(boolean headerAction) {
        if (headerAction) {
            return CommonActionsManager.getInstance().createCollapseAllHeaderAction(this.myTreeExpander, (JComponent)((Object)this));
        }
        return CommonActionsManager.getInstance().createCollapseAllAction(this.myTreeExpander, (JComponent)((Object)this));
    }

    public void setSelectionMode(@JdkConstants.TreeSelectionMode int mode) {
        this.getSelectionModel().setSelectionMode(mode);
    }

    @NotNull
    ThreeStateCheckBox.State getNodeStatus(@NotNull ChangesBrowserNode<?> node) {
        boolean hasIncluded = false;
        boolean hasExcluded = false;
        for (Object item : VcsTreeModelData.children(node).userObjects()) {
            ThreeStateCheckBox.State state = this.getInclusionModel().getInclusionState(item);
            if (state == ThreeStateCheckBox.State.SELECTED) {
                hasIncluded = true;
                continue;
            }
            if (state == ThreeStateCheckBox.State.NOT_SELECTED) {
                hasExcluded = true;
                continue;
            }
            hasIncluded = true;
            hasExcluded = true;
        }
        if (hasIncluded && hasExcluded) {
            return ThreeStateCheckBox.State.DONT_CARE;
        }
        if (hasIncluded) {
            return ThreeStateCheckBox.State.SELECTED;
        }
        return ThreeStateCheckBox.State.NOT_SELECTED;
    }

    protected boolean isInclusionEnabled(@NotNull ChangesBrowserNode<?> node) {
        return true;
    }

    protected boolean isInclusionVisible(@NotNull ChangesBrowserNode<?> node) {
        return true;
    }

    private boolean isIncludable(@NotNull TreePath path2) {
        Object lastComponent = path2.getLastPathComponent();
        if (!(lastComponent instanceof ChangesBrowserNode)) {
            return false;
        }
        return this.isIncludable((ChangesBrowserNode)lastComponent);
    }

    private boolean isIncludable(@NotNull ChangesBrowserNode<?> node) {
        return this.isInclusionVisible(node) && this.isInclusionEnabled(node);
    }

    @NotNull
    private List<Object> getIncludableUserObjects(@NotNull VcsTreeModelData treeModelData) {
        return treeModelData.nodesStream().filter(node -> this.isIncludable((ChangesBrowserNode<?>)node)).map(node -> node.getUserObject()).collect(Collectors.toList());
    }

    public void setSelectedChanges(@NotNull Collection<?> changes) {
        HashSet changesSet = new HashSet(changes);
        ArrayList treeSelection = new ArrayList(changes.size());
        TreeUtil.treeNodeTraverser(this.getRoot()).forEach(node -> {
            DefaultMutableTreeNode mutableNode = (DefaultMutableTreeNode)node;
            if (changesSet.contains(mutableNode.getUserObject())) {
                treeSelection.add(new TreePath(mutableNode.getPath()));
            }
        });
        this.setSelectionPaths(TreePathUtil.toTreePathArray(treeSelection));
        if (treeSelection.size() == 1) {
            this.scrollPathToVisible((TreePath)treeSelection.get(0));
        }
    }

    public boolean isKeepTreeState() {
        return this.myKeepTreeState;
    }

    public void setKeepTreeState(boolean keepTreeState) {
        this.myKeepTreeState = keepTreeState;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myTreeCopyProvider;
        }
        if (ChangesGroupingSupport.KEY.is(dataId)) {
            return this.myGroupingSupport;
        }
        if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
            return this.myTreeExpander;
        }
        return null;
    }

    public boolean isFileColorsEnabled() {
        return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
    }

    @Nullable
    public Color getFileColorForPath(@NotNull TreePath path2) {
        Object component = path2.getLastPathComponent();
        if (component instanceof ChangesBrowserNode) {
            return ((ChangesBrowserNode)component).getBackgroundColor(this.myProject);
        }
        return null;
    }

    public int getToggleClickCount() {
        return -1;
    }

    private class MyToggleSelectionAction
    extends AnAction
    implements DumbAware {
        private MyToggleSelectionAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(ChangesTree.this.isShowCheckboxes());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List changes = ChangesTree.this.getIncludableUserObjects(!ChangesTree.this.isSelectionEmpty() ? VcsTreeModelData.selected((JTree)((Object)ChangesTree.this)) : VcsTreeModelData.all((JTree)((Object)ChangesTree.this)));
            if (!changes.isEmpty()) {
                ChangesTree.this.toggleChanges(changes);
            }
        }
    }

    private class MyTreeExpander
    extends DefaultTreeExpander {
        MyTreeExpander() {
            super((JTree)((Object)ChangesTree.this));
        }

        public boolean isVisible(@NotNull AnActionEvent event) {
            return !ChangesTree.this.myGroupingSupport.isNone() || !ChangesTree.this.myIsModelFlat;
        }
    }
}

