/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserLockedFoldersNode
extends ChangesBrowserNode<Object>
implements TreeLinkMouseListener.HaveTooltip {
    @NotNull
    private static final SimpleTextAttributes CLEANUP_LINK_ATTRIBUTES = new SimpleTextAttributes(16, (Color)JBColor.RED);
    @NotNull
    private final Project myProject;

    public ChangesBrowserLockedFoldersNode(@NotNull Project project, @NotNull Object userObject) {
        super(userObject);
        this.myProject = project;
    }

    @NotNull
    public String getTooltip() {
        return VcsBundle.message((String)"changes.nodetitle.locked.folders.tooltip", (Object[])new Object[0]);
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        renderer.append(this.userObject.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        renderer.append(this.getCountText(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        renderer.append(FontUtil.spaceAndThinSpace(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        renderer.append("do cleanup...", CLEANUP_LINK_ATTRIBUTES, new CleanupWorker(this.myProject, this));
    }

    private static class CleanupWorker
    implements Runnable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ChangesBrowserNode<?> myNode;

        private CleanupWorker(@NotNull Project project, @NotNull ChangesBrowserNode<?> node) {
            this.myProject = project;
            this.myNode = node;
        }

        @Override
        public void run() {
            ChangesUtil.processVirtualFilesByVcs((Project)this.myProject, this.myNode.getAllFilesUnder(), (vcs, files) -> {
                ChangeProvider provider = vcs.getChangeProvider();
                if (provider != null) {
                    provider.doCleanup(files);
                }
            });
        }
    }
}

