/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.TreeActionsToolbarPanel;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangesBrowserBase
extends JPanel
implements DataProvider {
    public static final DataKey<ChangesBrowserBase> DATA_KEY = DataKey.create((String)"com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase");
    @NotNull
    protected final Project myProject;
    protected final ChangesTree myViewer;
    private final DefaultActionGroup myToolBarGroup = new DefaultActionGroup();
    private final DefaultActionGroup myPopupMenuGroup = new DefaultActionGroup();
    private final ActionToolbar myToolbar;
    private final int myToolbarAnchor;
    private final JScrollPane myViewerScrollPane;
    private final AnAction myShowDiffAction;
    @Nullable
    private Runnable myInclusionChangedListener;

    protected ChangesBrowserBase(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
        this.myProject = project;
        this.myViewer = this.createTreeList(project, showCheckboxes, highlightProblems);
        this.myToolbar = ActionManager.getInstance().createActionToolbar("ChangesBrowser", (ActionGroup)this.myToolBarGroup, true);
        this.myToolbar.setTargetComponent((JComponent)this);
        this.myToolbarAnchor = this.getToolbarAnchor();
        this.myToolbar.setOrientation(this.isVerticalToolbar() ? 1 : 0);
        this.myViewer.installPopupHandler((ActionGroup)this.myPopupMenuGroup);
        this.myViewerScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myViewer), (boolean)true);
        this.myViewerScrollPane.setBorder(this.createViewerBorder());
        this.myShowDiffAction = new MyShowDiffAction();
    }

    @NotNull
    protected ChangesBrowserTreeList createTreeList(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
        return new ChangesBrowserTreeList(this, project, showCheckboxes, highlightProblems);
    }

    protected void init() {
        List<AnAction> treeActions;
        boolean hasTreeActions;
        this.setLayout(new BorderLayout());
        this.setFocusable(false);
        JPanel topPanel = new JPanel(new BorderLayout());
        JComponent toolbarComponent = this.isVerticalToolbar() ? this.createToolbarComponent() : new TreeActionsToolbarPanel(this.createToolbarComponent(), this.myViewer);
        JComponent headerPanel = this.createHeaderPanel();
        if (headerPanel != null) {
            topPanel.add((Component)headerPanel, "East");
        }
        switch (this.myToolbarAnchor) {
            case 1: {
                topPanel.add((Component)toolbarComponent, "Center");
                break;
            }
            case 3: {
                this.add((Component)toolbarComponent, "South");
                break;
            }
            case 2: {
                this.add((Component)toolbarComponent, "West");
                break;
            }
            case 4: {
                this.add((Component)toolbarComponent, "East");
            }
        }
        this.add((Component)topPanel, "North");
        this.add((Component)this.createCenterPanel(), "Center");
        this.myToolBarGroup.addAll(this.createToolbarActions());
        this.myPopupMenuGroup.addAll(this.createPopupMenuActions());
        AnAction groupByAction = ActionManager.getInstance().getAction("ChangesView.GroupBy");
        if (!ActionUtil.recursiveContainsAction((ActionGroup)this.myToolBarGroup, (AnAction)groupByAction)) {
            this.myToolBarGroup.addSeparator();
            this.myToolBarGroup.add(groupByAction);
        }
        if (this.isVerticalToolbar() && !(hasTreeActions = ContainerUtil.exists(treeActions = TreeActionsToolbarPanel.createTreeActions(this.myViewer), action -> ActionUtil.recursiveContainsAction((ActionGroup)this.myToolBarGroup, (AnAction)action)))) {
            this.myToolBarGroup.addSeparator();
            this.myToolBarGroup.addAll(treeActions);
        }
        this.myShowDiffAction.registerCustomShortcutSet((JComponent)this, null);
    }

    @NotNull
    protected Border createViewerBorder() {
        return IdeBorderFactory.createBorder((int)15);
    }

    protected int getToolbarAnchor() {
        return 1;
    }

    private boolean isVerticalToolbar() {
        return this.myToolbarAnchor == 2 || this.myToolbarAnchor == 4;
    }

    @NotNull
    protected JComponent createToolbarComponent() {
        return this.myToolbar.getComponent();
    }

    @NotNull
    protected abstract DefaultTreeModel buildTreeModel();

    @Nullable
    protected ChangeDiffRequestChain.Producer getDiffRequestProducer(@NotNull Object userObject) {
        if (userObject instanceof Change) {
            return ChangeDiffRequestProducer.create(this.myProject, (Change)userObject);
        }
        return null;
    }

    @Nullable
    protected JComponent createHeaderPanel() {
        return null;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.myViewerScrollPane;
    }

    @NotNull
    protected List<AnAction> createToolbarActions() {
        return Collections.singletonList(this.myShowDiffAction);
    }

    @NotNull
    protected List<AnAction> createPopupMenuActions() {
        return Collections.singletonList(this.myShowDiffAction);
    }

    @NotNull
    protected List<AnAction> createDiffActions() {
        return Collections.emptyList();
    }

    protected void onDoubleClick() {
        if (this.canShowDiff()) {
            this.showDiff();
        }
    }

    protected void onIncludedChanged() {
        if (this.myInclusionChangedListener != null) {
            this.myInclusionChangedListener.run();
        }
    }

    public void selectEntries(@NotNull Collection<?> changes) {
        this.myViewer.setSelectedChanges(changes);
    }

    public void setInclusionChangedListener(@Nullable Runnable value) {
        this.myInclusionChangedListener = value;
    }

    public void addToolbarAction(@NotNull AnAction action) {
        this.myToolBarGroup.add(action);
    }

    public void addToolbarSeparator() {
        this.myToolBarGroup.addSeparator();
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.myViewer.getPreferredFocusedComponent();
    }

    @NotNull
    public ActionToolbar getToolbar() {
        return this.myToolbar;
    }

    @NotNull
    public JScrollPane getViewerScrollPane() {
        return this.myViewerScrollPane;
    }

    @NotNull
    public ChangesTree getViewer() {
        return this.myViewer;
    }

    @NotNull
    public ChangesGroupingPolicyFactory getGrouping() {
        return this.myViewer.getGrouping();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (DATA_KEY.is(dataId)) {
            return this;
        }
        Object viewerData = this.myViewer.getData(dataId);
        return viewerData != null ? viewerData : VcsTreeModelData.getData(this.myProject, (JTree)((Object)this.myViewer), dataId);
    }

    @NotNull
    public AnAction getDiffAction() {
        return this.myShowDiffAction;
    }

    public boolean canShowDiff() {
        ListSelection<Object> selection = VcsTreeModelData.getListSelectionOrAll((JTree)((Object)this.myViewer));
        return ContainerUtil.exists((Iterable)selection.getList(), entry -> this.getDiffRequestProducer(entry) != null);
    }

    public void showDiff() {
        ListSelection<Object> selection = VcsTreeModelData.getListSelectionOrAll((JTree)((Object)this.myViewer));
        ListSelection producers = selection.map(this::getDiffRequestProducer);
        ChangeDiffRequestChain chain = new ChangeDiffRequestChain(producers.getList(), producers.getSelectedIndex());
        this.updateDiffContext((DiffRequestChain)chain);
        DiffManager.getInstance().showDiff(this.myProject, (DiffRequestChain)chain, new DiffDialogHints(null, (Component)this));
    }

    protected void updateDiffContext(@NotNull DiffRequestChain chain) {
        chain.putUserData(DiffUserDataKeys.CONTEXT_ACTIONS, this.createDiffActions());
    }

    protected static class ChangesBrowserTreeList
    extends ChangesTree {
        @NotNull
        private final ChangesBrowserBase myViewer;

        public ChangesBrowserTreeList(@NotNull ChangesBrowserBase viewer, @NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
            super(project, showCheckboxes, highlightProblems);
            this.myViewer = viewer;
            this.setDoubleClickAndEnterKeyHandler(this.myViewer::onDoubleClick);
            this.setInclusionListener(this.myViewer::onIncludedChanged);
        }

        @Override
        public final void rebuildTree() {
            DefaultTreeModel newModel = this.myViewer.buildTreeModel();
            this.updateTreeModel(newModel);
        }
    }

    private class MyShowDiffAction
    extends DumbAwareAction
    implements UpdateInBackground {
        MyShowDiffAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Diff.ShowDiff");
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(ChangesBrowserBase.this.canShowDiff() || e.getInputEvent() instanceof KeyEvent);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (ChangesBrowserBase.this.canShowDiff()) {
                ChangesBrowserBase.this.showDiff();
            }
        }
    }
}

